package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: ArchiveAction.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/ArchiveAction.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import static org.nuiton.i18n.I18n.t;

import java.util.Date;

import javax.swing.JOptionPane;

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

/**
 * Action d'archivage d'un mail.
 * 
 * Passe le mail et statut archivé et déplace le mail dans le dossier d'archive le plus proche.
 * 
 * @author Kevin Morin (Code Lutin)
 */
public class ArchiveAction extends SaveDemandeAndExitAction {

    public ArchiveAction(DemandeUIHandler handler) {
        super(handler);
        setActionDescription(t("faxtomail.action.archive.tip"));
    }

    @Override
    public boolean prepareAction() throws Exception {
        int i = JOptionPane.showConfirmDialog(
                null,
                t("faxtomail.alert.archiveConfirmation.message"),
                t("faxtomail.alert.archiveConfirmation.title"),
                JOptionPane.YES_NO_OPTION,
                JOptionPane.QUESTION_MESSAGE);

        boolean result = i == JOptionPane.YES_OPTION;
        return result;
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel model = getModel();
        model.setArchiveDate(new Date());
        model.setDemandStatus(DemandStatus.ARCHIVED);
        model.setTakenBy(null);

        // déplacement du mail dans le dossier d'archive le plus proche
        // cela permet de déplacer les archives dans d'autre dossier pour leur appliquer
        // des droits différents
        // les dossiers d'archive ne sont pas visible dans l'arbre des dossiers, mais les archives
        // peuvent être consultées dans la recherche
        MailFolder folder = model.getMailFolder();
        MailFolder archiveChild = null;
        do {
            if (folder.getChildren() != null) {
                Optional<MailFolder> optArchiveChild = Iterables.tryFind(folder.getChildren(), new Predicate<MailFolder>() {
                    @Override
                    public boolean apply(MailFolder mailFolder) {
                        return mailFolder.isArchiveFolder();
                    }
                });
                if (optArchiveChild.isPresent()) {
                    archiveChild = optArchiveChild.get();
                }
            }
            folder = folder.getParent();

        } while (archiveChild == null && folder != null);

        // le dossier d'archive peut ne pas exister. Dans ce cas on laisse le mail dans le dossier
        // d'origine
        if (archiveChild != null) {
            model.setMailFolder(archiveChild);
        }

        super.doAction();
    }
}
