package com.franciaflex.faxtomail.services;

/*
 * #%L
 * FaxToMail :: Service
 * $Id: FaxToMailServiceUtils.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-service/src/main/java/com/franciaflex/faxtomail/services/FaxToMailServiceUtils.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.nio.charset.Charset;
import java.util.Collection;

import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;

import org.apache.commons.io.Charsets;

import com.franciaflex.faxtomail.persistence.entities.MailFolder;

/**
 * @author Kevin Morin (Code Lutin)
 */
public class FaxToMailServiceUtils {

    public static String addFaxDomainToFaxNumber(String faxNumber, MailFolder folder) {
        while (!folder.isUseCurrentLevelFaxDomain()
                && folder.getParent() != null) {
            folder = folder.getParent();
        }
        int endIndex = faxNumber.indexOf('@');
        if (endIndex >= 0) {
            faxNumber = faxNumber.substring(0, endIndex);
        }
        faxNumber += "@" + folder.getFaxDomain();
        return faxNumber;
    }

    public static Charset getCharset(Part part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String charsetName = contentType.getParameter("charset");
        Charset charset = Charsets.toCharset(charsetName);
        return charset;
    }

    /**
     * Return true if given collection is not null and contains requested value.
     * 
     * @param coll collection
     * @param value value
     * @return true if set contains value
     */
    public static <T extends Enum<T>> boolean contains(Collection<T> coll, T value) {
        boolean result = false;
        if (coll != null) {
            result = coll.contains(value);
        }
        return result;
    }
}
