/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.autocomplete.Util;

class TipUtil {
    private TipUtil() {
    }

    public static Color getToolTipBackground() {
        Color c = UIManager.getColor("ToolTip.background");
        if ((c == null || UIManager.getLookAndFeel().getName().equals("Nimbus")) && (c = UIManager.getColor("info")) == null) {
            c = SystemColor.info;
        }
        if (c instanceof ColorUIResource) {
            c = new Color(c.getRGB());
        }
        return c;
    }

    public static void tweakTipEditorPane(JEditorPane textArea) {
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            Color selBG = textArea.getSelectionColor();
            Color selFG = textArea.getSelectedTextColor();
            textArea.setUI(new BasicEditorPaneUI());
            textArea.setSelectedTextColor(selFG);
            textArea.setSelectionColor(selBG);
        }
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.getCaret().setSelectionVisible(true);
        Color fg = UIManager.getColor("Label.foreground");
        if (fg == null) {
            fg = SystemColor.text;
        }
        textArea.setForeground(fg);
        textArea.setBackground(TipUtil.getToolTipBackground());
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
        }
        HTMLDocument doc = (HTMLDocument)textArea.getDocument();
        doc.getStyleSheet().addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt" + "; color: " + Util.getHexString(fg) + "; }");
        URL url = TipUtil.class.getResource("bullet_black.png");
        if (url != null) {
            doc.getStyleSheet().addRule("ul { list-style-image: " + url.toString() + "; }");
        }
    }
}

