/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.fife.ui.autocomplete.CompletionProvider;

public abstract class CompletionProviderBase
implements CompletionProvider {
    private CompletionProvider parent;
    private ListCellRenderer listCellRenderer;
    private char paramListStart;
    private char paramListEnd;
    private String paramListSeparator;
    private boolean autoActivateAfterLetters;
    private String autoActivateChars;
    private Segment s = new Segment();
    protected static final String EMPTY_STRING = "";

    public void clearParameterizedCompletionParams() {
        this.paramListStart = '\u0000';
        this.paramListEnd = '\u0000';
        this.paramListSeparator = null;
    }

    public List getCompletions(JTextComponent comp) {
        List completions = this.getCompletionsImpl(comp);
        if (this.parent != null) {
            completions.addAll(this.parent.getCompletions(comp));
            Collections.sort(completions);
        }
        return completions;
    }

    protected abstract List getCompletionsImpl(JTextComponent var1);

    public ListCellRenderer getListCellRenderer() {
        return this.listCellRenderer;
    }

    public char getParameterListEnd() {
        return this.paramListEnd;
    }

    public String getParameterListSeparator() {
        return this.paramListSeparator;
    }

    public char getParameterListStart() {
        return this.paramListStart;
    }

    public CompletionProvider getParent() {
        return this.parent;
    }

    public boolean isAutoActivateOkay(JTextComponent tc) {
        Document doc = tc.getDocument();
        char ch = '\u0000';
        try {
            doc.getText(tc.getCaretPosition(), 1, this.s);
            ch = this.s.first();
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return this.autoActivateAfterLetters && Character.isLetter(ch) || this.autoActivateChars != null && this.autoActivateChars.indexOf(ch) > -1;
    }

    public void setAutoActivationRules(boolean letters, String others) {
        this.autoActivateAfterLetters = letters;
        this.autoActivateChars = others;
    }

    public void setListCellRenderer(ListCellRenderer r) {
        this.listCellRenderer = r;
    }

    public void setParameterizedCompletionParams(char listStart, String separator, char listEnd) {
        if (listStart < ' ' || listStart == '\u007f') {
            throw new IllegalArgumentException("Invalid listStart");
        }
        if (listEnd < ' ' || listEnd == '\u007f') {
            throw new IllegalArgumentException("Invalid listEnd");
        }
        if (separator == null || separator.length() == 0) {
            throw new IllegalArgumentException("Invalid separator");
        }
        this.paramListStart = listStart;
        this.paramListSeparator = separator;
        this.paramListEnd = listEnd;
    }

    public void setParent(CompletionProvider parent) {
        this.parent = parent;
    }
}

