/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.text.View;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;

public class CompletionCellRenderer
extends DefaultListCellRenderer {
    private static Color altBG;
    private Font font;
    private boolean showTypes;
    private boolean selected;
    private Color realBG;
    private Rectangle paintTextR;
    private static final String PREFIX = "<html><nobr>";

    public CompletionCellRenderer() {
        this.setShowTypes(true);
        this.paintTextR = new Rectangle();
    }

    public static Color getAlternateBackground() {
        return altBG;
    }

    public Font getDisplayFont() {
        return this.font;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        if (this.font != null) {
            this.setFont(this.font);
        }
        this.selected = selected;
        Color color = this.realBG = altBG != null && (index & 1) == 0 ? altBG : list.getBackground();
        if (value instanceof FunctionCompletion) {
            FunctionCompletion fc = (FunctionCompletion)value;
            this.prepareForFunctionCompletion(list, fc, index, selected, hasFocus);
        } else if (value instanceof VariableCompletion) {
            VariableCompletion vc = (VariableCompletion)value;
            this.prepareForVariableCompletion(list, vc, index, selected, hasFocus);
        } else if (value instanceof MarkupTagCompletion) {
            MarkupTagCompletion mtc = (MarkupTagCompletion)value;
            this.prepareForMarkupTagCompletion(list, mtc, index, selected, hasFocus);
        } else {
            Completion c = (Completion)value;
            this.prepareForOtherCompletion(list, c, index, selected, hasFocus);
        }
        if (!selected && (index & 1) == 0 && altBG != null) {
            this.setBackground(altBG);
        }
        return this;
    }

    public boolean getShowTypes() {
        return this.showTypes;
    }

    protected void paintComponent(Graphics g) {
        String text;
        g.setColor(this.realBG);
        int iconW = 0;
        if (this.getIcon() != null) {
            iconW = this.getIcon().getIconWidth();
        }
        if (this.selected && iconW > 0) {
            g.fillRect(0, 0, iconW, this.getHeight());
            g.setColor(this.getBackground());
            g.fillRect(iconW, 0, this.getWidth() - iconW, this.getHeight());
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.getIcon() != null) {
            this.getIcon().paintIcon(this, g, 0, 0);
        }
        if ((text = this.getText()) != null) {
            this.paintTextR.setBounds(iconW, 0, this.getWidth() - iconW, this.getHeight());
            this.paintTextR.x += 3;
            int space = this.paintTextR.height - g.getFontMetrics().getHeight();
            View v = (View)this.getClientProperty("html");
            if (v != null) {
                this.paintTextR.y += space / 2;
                this.paintTextR.height -= space;
                v.paint(g, this.paintTextR);
            } else {
                int textX = this.paintTextR.x;
                int textY = this.paintTextR.y;
                System.out.println(g.getFontMetrics().getAscent());
                g.drawString(text, textX, textY);
            }
        }
    }

    protected void prepareForFunctionCompletion(JList list, FunctionCompletion fc, int index, boolean selected, boolean hasFocus) {
        StringBuffer sb = new StringBuffer(PREFIX);
        sb.append(fc.getName());
        char paramListStart = fc.getProvider().getParameterListStart();
        if (paramListStart != '\u0000') {
            sb.append(paramListStart);
        }
        int paramCount = fc.getParamCount();
        for (int i = 0; i < paramCount; ++i) {
            ParameterizedCompletion.Parameter param = fc.getParam(i);
            String type = param.getType();
            String name = param.getName();
            if (type != null) {
                if (!selected) {
                    sb.append("<font color='#aa0077'>");
                }
                sb.append(type);
                if (!selected) {
                    sb.append("</font>");
                }
                if (name != null) {
                    sb.append(' ');
                }
            }
            if (name != null) {
                sb.append(name);
            }
            if (i >= paramCount - 1) continue;
            sb.append(fc.getProvider().getParameterListSeparator());
        }
        char paramListEnd = fc.getProvider().getParameterListEnd();
        if (paramListEnd != '\u0000') {
            sb.append(paramListEnd);
        }
        if (this.getShowTypes() && fc.getType() != null) {
            sb.append(" : ");
            if (!selected) {
                sb.append("<font color='#808080'>");
            }
            sb.append(fc.getType());
            if (!selected) {
                sb.append("</font>");
            }
        }
        this.setText(sb.toString());
    }

    protected void prepareForMarkupTagCompletion(JList list, MarkupTagCompletion mc, int index, boolean selected, boolean hasFocus) {
        StringBuffer sb = new StringBuffer(PREFIX);
        sb.append(mc.getName());
        this.setText(sb.toString());
    }

    protected void prepareForOtherCompletion(JList list, Completion c, int index, boolean selected, boolean hasFocus) {
        StringBuffer sb = new StringBuffer(PREFIX);
        sb.append(c.getInputText());
        this.setText(sb.toString());
    }

    protected void prepareForVariableCompletion(JList list, VariableCompletion vc, int index, boolean selected, boolean hasFocus) {
        StringBuffer sb = new StringBuffer(PREFIX);
        sb.append(vc.getName());
        if (this.getShowTypes() && vc.getType() != null) {
            sb.append(" : ");
            if (!selected) {
                sb.append("<font color='#808080'>");
            }
            sb.append(vc.getType());
            if (!selected) {
                sb.append("</font>");
            }
        }
        this.setText(sb.toString());
    }

    public static void setAlternateBackground(Color altBG) {
        CompletionCellRenderer.altBG = altBG;
    }

    public void setDisplayFont(Font font) {
        this.font = font;
    }

    public void setShowTypes(boolean show) {
        this.showTypes = show;
    }
}

