/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletePopupWindow;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.SizeGrip;
import org.fife.ui.autocomplete.TipUtil;
import org.fife.ui.autocomplete.Util;

class AutoCompleteDescWindow
extends JWindow
implements HyperlinkListener {
    private AutoCompletion ac;
    private JEditorPane descArea;
    private JScrollPane scrollPane;
    private JPanel bottomPanel;
    private JToolBar descWindowNavBar;
    private Action backAction;
    private Action forwardAction;
    private List history;
    private int historyPos;
    private Timer timer;
    private TimerAction timerAction;
    private ResourceBundle bundle;
    private static final int INITIAL_TIMER_DELAY = 120;
    private static final String MSG = "org.fife.ui.autocomplete.AutoCompleteDescWindow";

    public AutoCompleteDescWindow(Window owner, AutoCompletion ac) {
        super(owner);
        this.ac = ac;
        ComponentOrientation o = ac.getTextComponentOrientation();
        JPanel cp = new JPanel(new BorderLayout());
        this.descArea = new JEditorPane("text/html", null);
        TipUtil.tweakTipEditorPane(this.descArea);
        this.descArea.addHyperlinkListener(this);
        this.scrollPane = new JScrollPane(this.descArea);
        this.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setBackground(this.descArea.getBackground());
        this.scrollPane.getViewport().setBackground(this.descArea.getBackground());
        cp.add(this.scrollPane);
        this.descWindowNavBar = new JToolBar();
        this.backAction = new ToolBarBackAction(o.isLeftToRight());
        this.forwardAction = new ToolBarForwardAction(o.isLeftToRight());
        this.descWindowNavBar.setFloatable(false);
        this.descWindowNavBar.add(new JButton(this.backAction));
        this.descWindowNavBar.add(new JButton(this.forwardAction));
        this.bottomPanel = new JPanel(new BorderLayout());
        SizeGrip rp = new SizeGrip();
        this.bottomPanel.add((Component)this.descWindowNavBar, "Before");
        this.bottomPanel.add((Component)rp, "After");
        cp.add((Component)this.bottomPanel, "South");
        this.setContentPane(cp);
        this.applyComponentOrientation(o);
        this.setFocusableWindowState(false);
        this.history = new ArrayList(1);
        this.historyPos = -1;
        this.timerAction = new TimerAction();
        this.timer = new Timer(120, this.timerAction);
        this.timer.setRepeats(false);
    }

    private void addToHistory(String html) {
        this.history.add(++this.historyPos, html);
        this.clearHistoryAfterCurrentPos();
        this.setActionStates();
    }

    private void clearHistory() {
        this.history.clear();
        this.historyPos = -1;
        if (this.descWindowNavBar != null) {
            this.setActionStates();
        }
    }

    private void clearHistoryAfterCurrentPos() {
        for (int i = this.history.size() - 1; i > this.historyPos; --i) {
            this.history.remove(i);
        }
        this.setActionStates();
    }

    public boolean copy() {
        if (this.isVisible() && this.descArea.getSelectionStart() != this.descArea.getSelectionEnd()) {
            this.descArea.copy();
            return true;
        }
        return false;
    }

    private String getString(String key) {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(MSG);
        }
        return this.bundle.getString(key);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        if (type.equals(HyperlinkEvent.EventType.ACTIVATED)) {
            URL url = e.getURL();
            if (url != null) {
                ExternalURLHandler handler = this.ac.getExternalURLHandler();
                if (handler != null) {
                    handler.urlClicked(url);
                    return;
                }
                try {
                    Util.browse(new URI(url.toString()));
                }
                catch (URISyntaxException ioe) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.descArea);
                    ioe.printStackTrace();
                }
            } else {
                AutoCompletePopupWindow parent = (AutoCompletePopupWindow)this.getParent();
                CompletionProvider p = parent.getSelection().getProvider();
                if (p instanceof AbstractCompletionProvider) {
                    String name = e.getDescription();
                    List l = ((AbstractCompletionProvider)p).getCompletionByInputText(name);
                    if (l != null && !l.isEmpty()) {
                        Completion c = (Completion)l.get(0);
                        this.setDescriptionFor(c, true);
                    } else {
                        UIManager.getLookAndFeel().provideErrorFeedback(this.descArea);
                    }
                }
            }
        }
    }

    private void setActionStates() {
        this.backAction.setEnabled(this.historyPos > 0);
        this.forwardAction.setEnabled(this.historyPos > -1 && this.historyPos < this.history.size() - 1);
    }

    public void setDescriptionFor(Completion item) {
        this.setDescriptionFor(item, false);
    }

    protected void setDescriptionFor(Completion item, boolean addToHistory) {
        this.timer.stop();
        this.timerAction.setCompletion(item, addToHistory);
        this.timer.start();
    }

    private void setDisplayedDesc(String desc, boolean addToHistory) {
        if (desc == null) {
            desc = "<html><em>" + this.getString("NoDescAvailable") + "</em>";
        }
        this.descArea.setText(desc);
        this.descArea.setCaretPosition(0);
        if (!addToHistory) {
            this.clearHistory();
        }
        this.addToHistory(desc);
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.clearHistory();
        }
        super.setVisible(visible);
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        TipUtil.tweakTipEditorPane(this.descArea);
        this.scrollPane.setBackground(this.descArea.getBackground());
        this.scrollPane.getViewport().setBackground(this.descArea.getBackground());
    }

    class ToolBarForwardAction
    extends AbstractAction {
        public ToolBarForwardAction(boolean ltr) {
            String img = "org/fife/ui/autocomplete/arrow_" + (ltr ? "right.png" : "left.png");
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(img);
            try {
                ImageIcon icon = new ImageIcon(ImageIO.read(url));
                this.putValue("SmallIcon", icon);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.putValue("ShortDescription", "Forward");
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (AutoCompleteDescWindow.this.history != null && AutoCompleteDescWindow.this.historyPos < AutoCompleteDescWindow.this.history.size() - 1) {
                AutoCompleteDescWindow.this.descArea.setText((String)AutoCompleteDescWindow.this.history.get(++AutoCompleteDescWindow.this.historyPos));
                AutoCompleteDescWindow.this.descArea.setCaretPosition(0);
                AutoCompleteDescWindow.this.setActionStates();
            }
        }
    }

    class ToolBarBackAction
    extends AbstractAction {
        public ToolBarBackAction(boolean ltr) {
            String img = "org/fife/ui/autocomplete/arrow_" + (ltr ? "left.png" : "right.png");
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(img);
            try {
                ImageIcon icon = new ImageIcon(ImageIO.read(url));
                this.putValue("SmallIcon", icon);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.putValue("ShortDescription", "Back");
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (AutoCompleteDescWindow.this.historyPos > 0) {
                AutoCompleteDescWindow.this.descArea.setText((String)AutoCompleteDescWindow.this.history.get(--AutoCompleteDescWindow.this.historyPos));
                AutoCompleteDescWindow.this.descArea.setCaretPosition(0);
                AutoCompleteDescWindow.this.setActionStates();
            }
        }
    }

    private class TimerAction
    extends AbstractAction {
        private Completion completion;
        private boolean addToHistory;

        private TimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String desc = this.completion == null ? null : this.completion.getSummary();
            AutoCompleteDescWindow.this.setDisplayedDesc(desc, this.addToHistory);
        }

        public void setCompletion(Completion c, boolean addToHistory) {
            this.completion = c;
            this.addToHistory = addToHistory;
        }
    }
}

