/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProviderBase;

public abstract class AbstractCompletionProvider
extends CompletionProviderBase {
    protected List completions;
    protected Comparator comparator = new CaseInsensitiveComparator();

    public AbstractCompletionProvider() {
        this.clearParameterizedCompletionParams();
    }

    public void addCompletion(Completion c) {
        this.checkProviderAndAdd(c);
        Collections.sort(this.completions);
    }

    public void addCompletions(List completions) {
        for (int i = 0; i < completions.size(); ++i) {
            Completion c = (Completion)completions.get(i);
            this.checkProviderAndAdd(c);
        }
        Collections.sort(this.completions);
    }

    protected void addWordCompletions(String[] words) {
        int count = words == null ? 0 : words.length;
        for (int i = 0; i < count; ++i) {
            this.completions.add(new BasicCompletion(this, words[i]));
        }
        Collections.sort(this.completions);
    }

    protected void checkProviderAndAdd(Completion c) {
        if (c.getProvider() != this) {
            throw new IllegalArgumentException("Invalid CompletionProvider");
        }
        this.completions.add(c);
    }

    public void clear() {
        this.completions.clear();
    }

    public List getCompletionByInputText(String inputText) {
        int start;
        int end = Collections.binarySearch(this.completions, inputText, this.comparator);
        if (end < 0) {
            return null;
        }
        for (start = end; start > 0 && this.comparator.compare(this.completions.get(start - 1), inputText) == 0; --start) {
        }
        int count = this.completions.size();
        while (++end < count && this.comparator.compare(this.completions.get(end), inputText) == 0) {
        }
        return this.completions.subList(start, end);
    }

    protected List getCompletionsImpl(JTextComponent comp) {
        ArrayList retVal = new ArrayList();
        String text = this.getAlreadyEnteredText(comp);
        if (text != null) {
            Completion c;
            int index = Collections.binarySearch(this.completions, text, this.comparator);
            if (index < 0) {
                index = -index - 1;
            } else {
                for (int pos = index - 1; pos > 0 && this.comparator.compare(this.completions.get(pos), text) == 0; --pos) {
                    retVal.add(this.completions.get(pos));
                }
            }
            while (index < this.completions.size() && this.startsWithIgnoreCase((c = (Completion)this.completions.get(index)).getInputText(), text)) {
                retVal.add(c);
                ++index;
            }
        }
        return retVal;
    }

    public boolean removeCompletion(Completion c) {
        int index = Collections.binarySearch(this.completions, c);
        if (index < 0) {
            return false;
        }
        this.completions.remove(index);
        return true;
    }

    protected boolean startsWithIgnoreCase(String str, String start) {
        int startLen = start.length();
        if (str.length() >= startLen) {
            for (int i = 0; i < startLen; ++i) {
                char c1 = str.charAt(i);
                char c2 = start.charAt(i);
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class CaseInsensitiveComparator
    implements Comparator,
    Serializable {
        private CaseInsensitiveComparator() {
        }

        public int compare(Object o1, Object o2) {
            Completion c = (Completion)o1;
            return String.CASE_INSENSITIVE_ORDER.compare(c.getInputText(), o2);
        }
    }
}

