/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.parquetio.reader;

import com.exasol.errorreporting.ExaError;
import com.exasol.parquetio.data.ChunkInterval;
import com.exasol.parquetio.data.ChunkIntervalImpl;
import com.exasol.parquetio.data.Row;
import com.exasol.parquetio.merger.ChunkIntervalMerger;
import com.exasol.parquetio.reader.RowReadSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class RowParquetChunkReader {
    private static final String CHECK_FILE_MITIGATION = "Please make sure that the file is valid and not corrupted.";
    private final InputFile file;
    private final List<ChunkInterval> chunks;
    private final MessageColumnIO messageIO;
    private final RecordMaterializer<Row> recordMaterializer;

    public RowParquetChunkReader(InputFile file) {
        this(file, List.of(new ChunkIntervalImpl(0L, RowParquetChunkReader.getRowGroupSize(file))));
    }

    public RowParquetChunkReader(InputFile file, long start, long end) {
        this(file, List.of(new ChunkIntervalImpl(start, end)));
    }

    public RowParquetChunkReader(InputFile file, List<ChunkInterval> chunks) {
        this.file = file;
        if (chunks == null || chunks.isEmpty()) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PIOJ-5").message("Chunk intervals list is empty.", new Object[0]).mitigation("Please provide a valid list of Parquet file chunks.", new Object[0]).toString());
        }
        this.chunks = new ChunkIntervalMerger().sortAndMerge(chunks);
        RowReadSupport readSupport = new RowReadSupport();
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)file);){
            Configuration conf = this.getConfiguration(file);
            MessageType schema = reader.getFooter().getFileMetaData().getSchema();
            ReadSupport.ReadContext readContext = readSupport.init(conf, Collections.emptyMap(), schema);
            this.recordMaterializer = readSupport.prepareForRead(conf, Collections.emptyMap(), schema, readContext);
            this.messageIO = new ColumnIOFactory(reader.getFooter().getFileMetaData().getCreatedBy()).getColumnIO(readContext.getRequestedSchema(), schema, true);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(RowParquetChunkReader.getFileReadingErrorMessage(file), exception);
        }
        catch (RuntimeException exception) {
            throw new IllegalStateException(RowParquetChunkReader.getFileReadingErrorMessage(file), exception);
        }
    }

    private Configuration getConfiguration(InputFile file) {
        if (file instanceof HadoopInputFile) {
            return new Configuration(((HadoopInputFile)file).getConfiguration());
        }
        return new Configuration();
    }

    private static long getRowGroupSize(InputFile file) {
        long l;
        block9: {
            ParquetFileReader reader = ParquetFileReader.open((InputFile)file);
            try {
                l = reader.getRowGroups().size();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new UncheckedIOException(RowParquetChunkReader.getFileReadingErrorMessage(file), exception);
                }
                catch (RuntimeException exception) {
                    throw new IllegalStateException(ExaError.messageBuilder((String)"E-PIOJ-3").message("Error getting row group size from a Parquet {{FILE}} file.", new Object[]{file.toString()}).mitigation(CHECK_FILE_MITIGATION, new Object[0]).toString(), exception);
                }
            }
            reader.close();
        }
        return l;
    }

    public RowIterator iterator() {
        return new RowIterator(this.getReader(), this.file, this.messageIO, this.recordMaterializer, this.chunks);
    }

    private PositionAwareReader getReader() {
        try {
            return new PositionAwareReader(ParquetFileReader.open((InputFile)this.file));
        }
        catch (IOException exception) {
            throw new UncheckedIOException(RowParquetChunkReader.getFileReadingErrorMessage(this.file), exception);
        }
    }

    public void read(Consumer<Row> rowConsumer) {
        try (RowIterator iterator = this.iterator();){
            iterator.forEachRemaining(rowConsumer);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder((String)"E-PIOJ-6").message("Failed to close reader.", new Object[0]).toString(), exception);
        }
    }

    private static String getFileReadingErrorMessage(InputFile file) {
        return ExaError.messageBuilder((String)"E-PIOJ-1").message("Failed to read Parquet file {{FILE}}.", new Object[]{file.toString()}).mitigation(CHECK_FILE_MITIGATION, new Object[0]).toString();
    }

    protected static class RecordIterator
    implements Iterator<Row> {
        private final RecordReader<Row> recordReader;
        private final long totalRows;
        private final String fileNameForLogging;
        boolean hasNext = true;
        private long currentRow = 0L;
        private Row next = null;

        public RecordIterator(RecordReader<Row> recordReader, long totalRows, String fileNameForLogging) {
            this.recordReader = recordReader;
            this.totalRows = totalRows;
            this.fileNameForLogging = fileNameForLogging;
            this.loadNext();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Row next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Row result = this.next;
            this.loadNext();
            return result;
        }

        private void loadNext() {
            do {
                if (this.currentRow >= this.totalRows) {
                    this.hasNext = false;
                    return;
                }
                ++this.currentRow;
                try {
                    this.next = (Row)this.recordReader.read();
                }
                catch (RecordMaterializer.RecordMaterializationException exception) {
                    throw new ParquetDecodingException(ExaError.messageBuilder((String)"F-PIOJ-2").message("Failed to materialize a record from the Parquet file {{FILE}}.", new Object[]{this.fileNameForLogging}).mitigation(RowParquetChunkReader.CHECK_FILE_MITIGATION, new Object[0]).toString(), (Throwable)exception);
                }
                if (this.next != null) continue;
                this.hasNext = false;
                return;
            } while (this.recordReader.shouldSkipCurrentRecord());
        }
    }

    private static class PositionAwareReader
    implements AutoCloseable {
        private final ParquetFileReader reader;
        private long currentRowGroup;

        public PositionAwareReader(ParquetFileReader reader) {
            this.reader = reader;
            this.currentRowGroup = 0L;
        }

        public void moveToRowGroupPosition(long startPosition) {
            long position;
            for (position = this.currentRowGroup; position < startPosition; ++position) {
                this.reader.skipNextRowGroup();
            }
            this.currentRowGroup = position;
        }

        public PageReadStore readNextRowGroup() throws IOException {
            ++this.currentRowGroup;
            return this.reader.readNextRowGroup();
        }

        public long getCurrentRowGroup() {
            return this.currentRowGroup;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    public static class RowIterator
    implements Iterator<Row>,
    AutoCloseable {
        private final PositionAwareReader reader;
        private final InputFile file;
        private final MessageColumnIO messageIO;
        private final RecordMaterializer<Row> recordMaterializer;
        private final Iterator<ChunkInterval> chunkIterator;
        private Iterator<Long> rowGroupIterator = null;
        private Iterator<Row> rowInRowGroupIterator = null;
        private Row next = null;
        private boolean hasNext = true;

        public RowIterator(PositionAwareReader reader, InputFile file, MessageColumnIO messageIO, RecordMaterializer<Row> recordMaterializer, List<ChunkInterval> chunks) {
            this.reader = reader;
            this.file = file;
            this.messageIO = messageIO;
            this.recordMaterializer = recordMaterializer;
            this.chunkIterator = chunks.iterator();
            this.loadNext();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Row next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Row nextCache = this.next;
            this.loadNext();
            return nextCache;
        }

        private void loadNext() {
            try {
                while (this.rowInRowGroupIterator == null || !this.rowInRowGroupIterator.hasNext()) {
                    while (this.rowGroupIterator == null || !this.rowGroupIterator.hasNext()) {
                        if (!this.chunkIterator.hasNext()) {
                            this.hasNext = false;
                            return;
                        }
                        ChunkInterval chunk = this.chunkIterator.next();
                        this.reader.moveToRowGroupPosition(chunk.getStartPosition());
                        long endPosition = chunk.getEndPosition();
                        this.rowGroupIterator = LongStream.range(this.reader.getCurrentRowGroup(), endPosition).iterator();
                    }
                    this.rowGroupIterator.next();
                    PageReadStore pageStore = this.reader.readNextRowGroup();
                    RecordReader recordReader = this.messageIO.getRecordReader(pageStore, this.recordMaterializer, FilterCompat.NOOP);
                    this.rowInRowGroupIterator = new RecordIterator((RecordReader<Row>)recordReader, pageStore.getRowCount(), this.file.toString());
                }
                this.next = this.rowInRowGroupIterator.next();
            }
            catch (IOException exception) {
                throw new UncheckedIOException(RowParquetChunkReader.getFileReadingErrorMessage(this.file), exception);
            }
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

