/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AddOn;
import com.docusign.esign.model.DowngradePlanUpdateResponse;
import com.docusign.esign.model.FeatureSet;
import com.docusign.esign.model.SeatDiscount;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Contains information about an account billing plan.")
public class AccountBillingPlan
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="addOns")
    private List<AddOn> addOns = null;
    @JsonProperty(value="appStoreReceiptExpirationDate")
    private String appStoreReceiptExpirationDate = null;
    @JsonProperty(value="appStoreReceiptPurchaseDate")
    private String appStoreReceiptPurchaseDate = null;
    @JsonProperty(value="canCancelRenewal")
    private String canCancelRenewal = null;
    @JsonProperty(value="canUpgrade")
    private String canUpgrade = null;
    @JsonProperty(value="currencyCode")
    private String currencyCode = null;
    @JsonProperty(value="downgradePlanInformation")
    private DowngradePlanUpdateResponse downgradePlanInformation = null;
    @JsonProperty(value="enableSupport")
    private String enableSupport = null;
    @JsonProperty(value="includedSeats")
    private String includedSeats = null;
    @JsonProperty(value="incrementalSeats")
    private String incrementalSeats = null;
    @JsonProperty(value="isDowngrade")
    private String isDowngrade = null;
    @JsonProperty(value="notificationType")
    private String notificationType = null;
    @JsonProperty(value="otherDiscountPercent")
    private String otherDiscountPercent = null;
    @JsonProperty(value="paymentCycle")
    private String paymentCycle = null;
    @JsonProperty(value="paymentMethod")
    private String paymentMethod = null;
    @JsonProperty(value="perSeatPrice")
    private String perSeatPrice = null;
    @JsonProperty(value="planClassification")
    private String planClassification = null;
    @JsonProperty(value="planFeatureSets")
    private List<FeatureSet> planFeatureSets = null;
    @JsonProperty(value="planId")
    private String planId = null;
    @JsonProperty(value="planName")
    private String planName = null;
    @JsonProperty(value="planStartDate")
    private String planStartDate = null;
    @JsonProperty(value="productId")
    private String productId = null;
    @JsonProperty(value="renewalDate")
    private String renewalDate = null;
    @JsonProperty(value="renewalStatus")
    private String renewalStatus = null;
    @JsonProperty(value="seatDiscounts")
    private List<SeatDiscount> seatDiscounts = null;
    @JsonProperty(value="subscriptionStartDate")
    private String subscriptionStartDate = null;
    @JsonProperty(value="supportIncidentFee")
    private String supportIncidentFee = null;
    @JsonProperty(value="supportPlanFee")
    private String supportPlanFee = null;
    @JsonProperty(value="taxExemptId")
    private String taxExemptId = null;

    public AccountBillingPlan addOns(List<AddOn> addOns) {
        this.addOns = addOns;
        return this;
    }

    public AccountBillingPlan addAddOnsItem(AddOn addOnsItem) {
        if (this.addOns == null) {
            this.addOns = new ArrayList<AddOn>();
        }
        this.addOns.add(addOnsItem);
        return this;
    }

    @Schema(description="Reserved:")
    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(List<AddOn> addOns) {
        this.addOns = addOns;
    }

    public AccountBillingPlan appStoreReceiptExpirationDate(String appStoreReceiptExpirationDate) {
        this.appStoreReceiptExpirationDate = appStoreReceiptExpirationDate;
        return this;
    }

    @Schema(description="")
    public String getAppStoreReceiptExpirationDate() {
        return this.appStoreReceiptExpirationDate;
    }

    public void setAppStoreReceiptExpirationDate(String appStoreReceiptExpirationDate) {
        this.appStoreReceiptExpirationDate = appStoreReceiptExpirationDate;
    }

    public AccountBillingPlan appStoreReceiptPurchaseDate(String appStoreReceiptPurchaseDate) {
        this.appStoreReceiptPurchaseDate = appStoreReceiptPurchaseDate;
        return this;
    }

    @Schema(description="")
    public String getAppStoreReceiptPurchaseDate() {
        return this.appStoreReceiptPurchaseDate;
    }

    public void setAppStoreReceiptPurchaseDate(String appStoreReceiptPurchaseDate) {
        this.appStoreReceiptPurchaseDate = appStoreReceiptPurchaseDate;
    }

    public AccountBillingPlan canCancelRenewal(String canCancelRenewal) {
        this.canCancelRenewal = canCancelRenewal;
        return this;
    }

    @Schema(description="Reserved: TBD")
    public String getCanCancelRenewal() {
        return this.canCancelRenewal;
    }

    public void setCanCancelRenewal(String canCancelRenewal) {
        this.canCancelRenewal = canCancelRenewal;
    }

    public AccountBillingPlan canUpgrade(String canUpgrade) {
        this.canUpgrade = canUpgrade;
        return this;
    }

    @Schema(description="When set to **true**, specifies that you can upgrade the account through the API.")
    public String getCanUpgrade() {
        return this.canUpgrade;
    }

    public void setCanUpgrade(String canUpgrade) {
        this.canUpgrade = canUpgrade;
    }

    public AccountBillingPlan currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(description="Specifies the ISO currency code for the account.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public AccountBillingPlan downgradePlanInformation(DowngradePlanUpdateResponse downgradePlanInformation) {
        this.downgradePlanInformation = downgradePlanInformation;
        return this;
    }

    @Schema(description="")
    public DowngradePlanUpdateResponse getDowngradePlanInformation() {
        return this.downgradePlanInformation;
    }

    public void setDowngradePlanInformation(DowngradePlanUpdateResponse downgradePlanInformation) {
        this.downgradePlanInformation = downgradePlanInformation;
    }

    public AccountBillingPlan enableSupport(String enableSupport) {
        this.enableSupport = enableSupport;
        return this;
    }

    @Schema(description="When set to **true**, then customer support is provided as part of the account plan.")
    public String getEnableSupport() {
        return this.enableSupport;
    }

    public void setEnableSupport(String enableSupport) {
        this.enableSupport = enableSupport;
    }

    public AccountBillingPlan includedSeats(String includedSeats) {
        this.includedSeats = includedSeats;
        return this;
    }

    @Schema(description="The number of seats (users) included.")
    public String getIncludedSeats() {
        return this.includedSeats;
    }

    public void setIncludedSeats(String includedSeats) {
        this.includedSeats = includedSeats;
    }

    public AccountBillingPlan incrementalSeats(String incrementalSeats) {
        this.incrementalSeats = incrementalSeats;
        return this;
    }

    @Schema(description="Reserved: TBD")
    public String getIncrementalSeats() {
        return this.incrementalSeats;
    }

    public void setIncrementalSeats(String incrementalSeats) {
        this.incrementalSeats = incrementalSeats;
    }

    public AccountBillingPlan isDowngrade(String isDowngrade) {
        this.isDowngrade = isDowngrade;
        return this;
    }

    @Schema(description="")
    public String getIsDowngrade() {
        return this.isDowngrade;
    }

    public void setIsDowngrade(String isDowngrade) {
        this.isDowngrade = isDowngrade;
    }

    public AccountBillingPlan notificationType(String notificationType) {
        this.notificationType = notificationType;
        return this;
    }

    @Schema(description="")
    public String getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public AccountBillingPlan otherDiscountPercent(String otherDiscountPercent) {
        this.otherDiscountPercent = otherDiscountPercent;
        return this;
    }

    @Schema(description=" Any other percentage discount for the plan. ")
    public String getOtherDiscountPercent() {
        return this.otherDiscountPercent;
    }

    public void setOtherDiscountPercent(String otherDiscountPercent) {
        this.otherDiscountPercent = otherDiscountPercent;
    }

    public AccountBillingPlan paymentCycle(String paymentCycle) {
        this.paymentCycle = paymentCycle;
        return this;
    }

    @Schema(description="")
    public String getPaymentCycle() {
        return this.paymentCycle;
    }

    public void setPaymentCycle(String paymentCycle) {
        this.paymentCycle = paymentCycle;
    }

    public AccountBillingPlan paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description=" The payment method used with the plan. The possible values are: CreditCard, PurchaseOrder, Premium, or Freemium. ")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public AccountBillingPlan perSeatPrice(String perSeatPrice) {
        this.perSeatPrice = perSeatPrice;
        return this;
    }

    @Schema(description="")
    public String getPerSeatPrice() {
        return this.perSeatPrice;
    }

    public void setPerSeatPrice(String perSeatPrice) {
        this.perSeatPrice = perSeatPrice;
    }

    public AccountBillingPlan planClassification(String planClassification) {
        this.planClassification = planClassification;
        return this;
    }

    @Schema(description="Identifies the type of plan. Examples include Business, Corporate, Enterprise, Free.")
    public String getPlanClassification() {
        return this.planClassification;
    }

    public void setPlanClassification(String planClassification) {
        this.planClassification = planClassification;
    }

    public AccountBillingPlan planFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
        return this;
    }

    public AccountBillingPlan addPlanFeatureSetsItem(FeatureSet planFeatureSetsItem) {
        if (this.planFeatureSets == null) {
            this.planFeatureSets = new ArrayList<FeatureSet>();
        }
        this.planFeatureSets.add(planFeatureSetsItem);
        return this;
    }

    @Schema(description="A complex type that sets the feature sets for the account. It contains the following information (all string content):  * currencyFeatureSetPrices - Contains the currencyCode and currencySymbol for the alternate currency values for envelopeFee, fixedFee, seatFee that are configured for this plan feature set. * envelopeFee - An incremental envelope cost for plans with envelope overages (when isEnabled=true). * featureSetId - A unique ID for the feature set. * fixedFee - A one-time fee associated with the plan (when isEnabled=true). * isActive - Specifies whether the feature set is actively set as part of the plan. * isEnabled - Specifies whether the feature set is actively enabled as part of the plan. * name - The name of the feature set. * seatFee - An incremental seat cost for seat-based plans (when isEnabled=true). ")
    public List<FeatureSet> getPlanFeatureSets() {
        return this.planFeatureSets;
    }

    public void setPlanFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
    }

    public AccountBillingPlan planId(String planId) {
        this.planId = planId;
        return this;
    }

    @Schema(description="")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public AccountBillingPlan planName(String planName) {
        this.planName = planName;
        return this;
    }

    @Schema(description="The name of the Billing Plan.")
    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public AccountBillingPlan planStartDate(String planStartDate) {
        this.planStartDate = planStartDate;
        return this;
    }

    @Schema(description="")
    public String getPlanStartDate() {
        return this.planStartDate;
    }

    public void setPlanStartDate(String planStartDate) {
        this.planStartDate = planStartDate;
    }

    public AccountBillingPlan productId(String productId) {
        this.productId = productId;
        return this;
    }

    @Schema(description="")
    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public AccountBillingPlan renewalDate(String renewalDate) {
        this.renewalDate = renewalDate;
        return this;
    }

    @Schema(description="")
    public String getRenewalDate() {
        return this.renewalDate;
    }

    public void setRenewalDate(String renewalDate) {
        this.renewalDate = renewalDate;
    }

    public AccountBillingPlan renewalStatus(String renewalStatus) {
        this.renewalStatus = renewalStatus;
        return this;
    }

    @Schema(description="The renewal status for the account. The acceptable values are:  * auto: The account automatically renews. * queued_for_close: Account will be closed at the billingPeriodEndDate. * queued_for_downgrade: Account will be downgraded at the billingPeriodEndDate.")
    public String getRenewalStatus() {
        return this.renewalStatus;
    }

    public void setRenewalStatus(String renewalStatus) {
        this.renewalStatus = renewalStatus;
    }

    public AccountBillingPlan seatDiscounts(List<SeatDiscount> seatDiscounts) {
        this.seatDiscounts = seatDiscounts;
        return this;
    }

    public AccountBillingPlan addSeatDiscountsItem(SeatDiscount seatDiscountsItem) {
        if (this.seatDiscounts == null) {
            this.seatDiscounts = new ArrayList<SeatDiscount>();
        }
        this.seatDiscounts.add(seatDiscountsItem);
        return this;
    }

    @Schema(description=" A complex type that contains any seat discount information.  Values are: BeginSeatCount, EndSeatCount, and SeatDiscountPercent.  ")
    public List<SeatDiscount> getSeatDiscounts() {
        return this.seatDiscounts;
    }

    public void setSeatDiscounts(List<SeatDiscount> seatDiscounts) {
        this.seatDiscounts = seatDiscounts;
    }

    public AccountBillingPlan subscriptionStartDate(String subscriptionStartDate) {
        this.subscriptionStartDate = subscriptionStartDate;
        return this;
    }

    @Schema(description="")
    public String getSubscriptionStartDate() {
        return this.subscriptionStartDate;
    }

    public void setSubscriptionStartDate(String subscriptionStartDate) {
        this.subscriptionStartDate = subscriptionStartDate;
    }

    public AccountBillingPlan supportIncidentFee(String supportIncidentFee) {
        this.supportIncidentFee = supportIncidentFee;
        return this;
    }

    @Schema(description="The support incident fee charged for each support incident.")
    public String getSupportIncidentFee() {
        return this.supportIncidentFee;
    }

    public void setSupportIncidentFee(String supportIncidentFee) {
        this.supportIncidentFee = supportIncidentFee;
    }

    public AccountBillingPlan supportPlanFee(String supportPlanFee) {
        this.supportPlanFee = supportPlanFee;
        return this;
    }

    @Schema(description="The support plan fee charged for this plan.")
    public String getSupportPlanFee() {
        return this.supportPlanFee;
    }

    public void setSupportPlanFee(String supportPlanFee) {
        this.supportPlanFee = supportPlanFee;
    }

    public AccountBillingPlan taxExemptId(String taxExemptId) {
        this.taxExemptId = taxExemptId;
        return this;
    }

    @Schema(description="")
    public String getTaxExemptId() {
        return this.taxExemptId;
    }

    public void setTaxExemptId(String taxExemptId) {
        this.taxExemptId = taxExemptId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountBillingPlan accountBillingPlan = (AccountBillingPlan)o;
        return Objects.equals(this.addOns, accountBillingPlan.addOns) && Objects.equals(this.appStoreReceiptExpirationDate, accountBillingPlan.appStoreReceiptExpirationDate) && Objects.equals(this.appStoreReceiptPurchaseDate, accountBillingPlan.appStoreReceiptPurchaseDate) && Objects.equals(this.canCancelRenewal, accountBillingPlan.canCancelRenewal) && Objects.equals(this.canUpgrade, accountBillingPlan.canUpgrade) && Objects.equals(this.currencyCode, accountBillingPlan.currencyCode) && Objects.equals(this.downgradePlanInformation, accountBillingPlan.downgradePlanInformation) && Objects.equals(this.enableSupport, accountBillingPlan.enableSupport) && Objects.equals(this.includedSeats, accountBillingPlan.includedSeats) && Objects.equals(this.incrementalSeats, accountBillingPlan.incrementalSeats) && Objects.equals(this.isDowngrade, accountBillingPlan.isDowngrade) && Objects.equals(this.notificationType, accountBillingPlan.notificationType) && Objects.equals(this.otherDiscountPercent, accountBillingPlan.otherDiscountPercent) && Objects.equals(this.paymentCycle, accountBillingPlan.paymentCycle) && Objects.equals(this.paymentMethod, accountBillingPlan.paymentMethod) && Objects.equals(this.perSeatPrice, accountBillingPlan.perSeatPrice) && Objects.equals(this.planClassification, accountBillingPlan.planClassification) && Objects.equals(this.planFeatureSets, accountBillingPlan.planFeatureSets) && Objects.equals(this.planId, accountBillingPlan.planId) && Objects.equals(this.planName, accountBillingPlan.planName) && Objects.equals(this.planStartDate, accountBillingPlan.planStartDate) && Objects.equals(this.productId, accountBillingPlan.productId) && Objects.equals(this.renewalDate, accountBillingPlan.renewalDate) && Objects.equals(this.renewalStatus, accountBillingPlan.renewalStatus) && Objects.equals(this.seatDiscounts, accountBillingPlan.seatDiscounts) && Objects.equals(this.subscriptionStartDate, accountBillingPlan.subscriptionStartDate) && Objects.equals(this.supportIncidentFee, accountBillingPlan.supportIncidentFee) && Objects.equals(this.supportPlanFee, accountBillingPlan.supportPlanFee) && Objects.equals(this.taxExemptId, accountBillingPlan.taxExemptId);
    }

    public int hashCode() {
        return Objects.hash(this.addOns, this.appStoreReceiptExpirationDate, this.appStoreReceiptPurchaseDate, this.canCancelRenewal, this.canUpgrade, this.currencyCode, this.downgradePlanInformation, this.enableSupport, this.includedSeats, this.incrementalSeats, this.isDowngrade, this.notificationType, this.otherDiscountPercent, this.paymentCycle, this.paymentMethod, this.perSeatPrice, this.planClassification, this.planFeatureSets, this.planId, this.planName, this.planStartDate, this.productId, this.renewalDate, this.renewalStatus, this.seatDiscounts, this.subscriptionStartDate, this.supportIncidentFee, this.supportPlanFee, this.taxExemptId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountBillingPlan {\n");
        sb.append("    addOns: ").append(this.toIndentedString(this.addOns)).append("\n");
        sb.append("    appStoreReceiptExpirationDate: ").append(this.toIndentedString(this.appStoreReceiptExpirationDate)).append("\n");
        sb.append("    appStoreReceiptPurchaseDate: ").append(this.toIndentedString(this.appStoreReceiptPurchaseDate)).append("\n");
        sb.append("    canCancelRenewal: ").append(this.toIndentedString(this.canCancelRenewal)).append("\n");
        sb.append("    canUpgrade: ").append(this.toIndentedString(this.canUpgrade)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    downgradePlanInformation: ").append(this.toIndentedString(this.downgradePlanInformation)).append("\n");
        sb.append("    enableSupport: ").append(this.toIndentedString(this.enableSupport)).append("\n");
        sb.append("    includedSeats: ").append(this.toIndentedString(this.includedSeats)).append("\n");
        sb.append("    incrementalSeats: ").append(this.toIndentedString(this.incrementalSeats)).append("\n");
        sb.append("    isDowngrade: ").append(this.toIndentedString(this.isDowngrade)).append("\n");
        sb.append("    notificationType: ").append(this.toIndentedString(this.notificationType)).append("\n");
        sb.append("    otherDiscountPercent: ").append(this.toIndentedString(this.otherDiscountPercent)).append("\n");
        sb.append("    paymentCycle: ").append(this.toIndentedString(this.paymentCycle)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    perSeatPrice: ").append(this.toIndentedString(this.perSeatPrice)).append("\n");
        sb.append("    planClassification: ").append(this.toIndentedString(this.planClassification)).append("\n");
        sb.append("    planFeatureSets: ").append(this.toIndentedString(this.planFeatureSets)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    planName: ").append(this.toIndentedString(this.planName)).append("\n");
        sb.append("    planStartDate: ").append(this.toIndentedString(this.planStartDate)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    renewalDate: ").append(this.toIndentedString(this.renewalDate)).append("\n");
        sb.append("    renewalStatus: ").append(this.toIndentedString(this.renewalStatus)).append("\n");
        sb.append("    seatDiscounts: ").append(this.toIndentedString(this.seatDiscounts)).append("\n");
        sb.append("    subscriptionStartDate: ").append(this.toIndentedString(this.subscriptionStartDate)).append("\n");
        sb.append("    supportIncidentFee: ").append(this.toIndentedString(this.supportIncidentFee)).append("\n");
        sb.append("    supportPlanFee: ").append(this.toIndentedString(this.supportPlanFee)).append("\n");
        sb.append("    taxExemptId: ").append(this.toIndentedString(this.taxExemptId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

