/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import com.azure.security.keyvault.secrets.implementation.models.SecretBundle;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedSecretBundle
extends SecretBundle {
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;
    private Boolean managed;
    private String kid;

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public DeletedSecretBundle setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    @Override
    public Boolean isManaged() {
        return this.managed;
    }

    @Override
    public String getKid() {
        return this.kid;
    }

    @Override
    public DeletedSecretBundle setValue(String value) {
        super.setValue(value);
        return this;
    }

    @Override
    public DeletedSecretBundle setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public DeletedSecretBundle setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public DeletedSecretBundle setAttributes(SecretAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    @Override
    public DeletedSecretBundle setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.getValue());
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeStringField("contentType", this.getContentType());
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.getAttributes());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedSecretBundle fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedSecretBundle)jsonReader.readObject(reader -> {
            DeletedSecretBundle deserializedDeletedSecretBundle = new DeletedSecretBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setValue(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setId(reader.getString());
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setContentType(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setAttributes(SecretAttributes.fromJson(reader));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedSecretBundle.setTags(tags);
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deserializedDeletedSecretBundle.kid = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedDeletedSecretBundle.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedSecretBundle.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedSecretBundle.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedSecretBundle.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedSecretBundle;
        });
    }
}

