/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.models.TableAccessPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableSignedIdentifier
implements XmlSerializable<TableSignedIdentifier> {
    private String id;
    private TableAccessPolicy accessPolicy;

    public TableSignedIdentifier(String id) {
        this.id = Objects.requireNonNull(id, "'id' cannot be null");
    }

    public String getId() {
        return this.id;
    }

    public TableAccessPolicy getAccessPolicy() {
        return this.accessPolicy;
    }

    public TableSignedIdentifier setAccessPolicy(TableAccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifier" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.accessPolicy, "AccessPolicy");
        return xmlWriter.writeEndElement();
    }

    public static TableSignedIdentifier fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableSignedIdentifier.fromXml(xmlReader, null);
    }

    public static TableSignedIdentifier fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifier" : rootElementName;
        return (TableSignedIdentifier)xmlReader.readObject(finalRootElementName, reader -> {
            TableSignedIdentifier deserializedTableSignedIdentifier = new TableSignedIdentifier();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Id".equals(elementName.getLocalPart())) {
                    deserializedTableSignedIdentifier.id = reader.getStringElement();
                    continue;
                }
                if ("AccessPolicy".equals(elementName.getLocalPart())) {
                    deserializedTableSignedIdentifier.accessPolicy = TableAccessPolicy.fromXml(reader, "AccessPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTableSignedIdentifier;
        });
    }

    private TableSignedIdentifier() {
    }
}

