/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.data.tables.TableAzureNamedKeyCredentialPolicy;
import com.azure.data.tables.implementation.StorageConstants;
import com.azure.data.tables.implementation.TableUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TableSasUtils {
    public static void tryAppendQueryParameter(StringBuilder sb, String param, Object value) {
        if (value != null) {
            if (sb.length() != 0) {
                sb.append('&');
            }
            sb.append(TableUtils.urlEncode(param)).append('=').append(TableUtils.urlEncode(value.toString()));
        }
    }

    public static String formatQueryParameterDate(OffsetDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return StorageConstants.ISO_8601_UTC_DATE_FORMATTER.format(dateTime);
    }

    public static AzureNamedKeyCredential extractNamedKeyCredential(HttpPipeline pipeline) {
        for (int i = 0; i < pipeline.getPolicyCount(); ++i) {
            if (!(pipeline.getPolicy(i) instanceof TableAzureNamedKeyCredentialPolicy)) continue;
            TableAzureNamedKeyCredentialPolicy policy = (TableAzureNamedKeyCredentialPolicy)pipeline.getPolicy(i);
            return policy.getCredential();
        }
        return null;
    }

    public static String computeHmac256(String base64Key, String stringToSign) {
        try {
            byte[] key = Base64.getDecoder().decode(base64Key);
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            hmacSHA256.init(new SecretKeySpec(key, "HmacSHA256"));
            byte[] utf8Bytes = stringToSign.getBytes(StandardCharsets.UTF_8);
            return Base64.getEncoder().encodeToString(hmacSHA256.doFinal(utf8Bytes));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

