// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure App Configuration error object.
 */
@Fluent
public final class Error implements JsonSerializable<Error> {
    /*
     * The type of the error.
     */
    private String type;

    /*
     * A brief summary of the error.
     */
    private String title;

    /*
     * The name of the parameter that resulted in the error.
     */
    private String name;

    /*
     * A detailed description of the error.
     */
    private String detail;

    /*
     * The HTTP status code that the error maps to.
     */
    private Integer status;

    /**
     * Creates an instance of Error class.
     */
    public Error() {
    }

    /**
     * Get the type property: The type of the error.
     * 
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: The type of the error.
     * 
     * @param type the type value to set.
     * @return the Error object itself.
     */
    public Error setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the title property: A brief summary of the error.
     * 
     * @return the title value.
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * Set the title property: A brief summary of the error.
     * 
     * @param title the title value to set.
     * @return the Error object itself.
     */
    public Error setTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the name property: The name of the parameter that resulted in the error.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of the parameter that resulted in the error.
     * 
     * @param name the name value to set.
     * @return the Error object itself.
     */
    public Error setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the detail property: A detailed description of the error.
     * 
     * @return the detail value.
     */
    public String getDetail() {
        return this.detail;
    }

    /**
     * Set the detail property: A detailed description of the error.
     * 
     * @param detail the detail value to set.
     * @return the Error object itself.
     */
    public Error setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    /**
     * Get the status property: The HTTP status code that the error maps to.
     * 
     * @return the status value.
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The HTTP status code that the error maps to.
     * 
     * @param status the status value to set.
     * @return the Error object itself.
     */
    public Error setStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("detail", this.detail);
        jsonWriter.writeNumberField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Error from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Error if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Error.
     */
    public static Error fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Error deserializedError = new Error();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedError.type = reader.getString();
                } else if ("title".equals(fieldName)) {
                    deserializedError.title = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedError.name = reader.getString();
                } else if ("detail".equals(fieldName)) {
                    deserializedError.detail = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedError.status = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedError;
        });
    }
}
