// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The result of a list request.
 */
@Fluent
public final class KeyListResult implements JsonSerializable<KeyListResult> {
    /*
     * The collection value.
     */
    private List<Key> items;

    /*
     * The URI that can be used to request the next set of paged results.
     */
    private String nextLink;

    /**
     * Creates an instance of KeyListResult class.
     */
    public KeyListResult() {
    }

    /**
     * Get the items property: The collection value.
     * 
     * @return the items value.
     */
    public List<Key> getItems() {
        return this.items;
    }

    /**
     * Set the items property: The collection value.
     * 
     * @param items the items value to set.
     * @return the KeyListResult object itself.
     */
    public KeyListResult setItems(List<Key> items) {
        this.items = items;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the KeyListResult object itself.
     */
    public KeyListResult setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("items", this.items, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("@nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyListResult.
     */
    public static KeyListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyListResult deserializedKeyListResult = new KeyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("items".equals(fieldName)) {
                    List<Key> items = reader.readArray(reader1 -> Key.fromJson(reader1));
                    deserializedKeyListResult.items = items;
                } else if ("@nextLink".equals(fieldName)) {
                    deserializedKeyListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyListResult;
        });
    }
}
