/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Expression;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;

public class GetSignaturesDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"PackageManagerGetSignatures", (String)"Potential Multiple Certificate Exploit", (String)"Improper validation of app signatures could lead to issues where a malicious app submits itself to the Play Store with both its real certificate and a fake certificate and gains access to functionality or information it shouldn't have due to another application only checking for the fake certificate and ignoring the rest. Please make sure to validate all signatures returned by this method.", (Category)Category.SECURITY, (int)8, (Severity)Severity.INFORMATIONAL, (Implementation)new Implementation(GetSignaturesDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://bluebox.com/technical/android-fake-id-vulnerability/");
    private static final String PACKAGE_MANAGER_CLASS = "android.content.pm.PackageManager";
    private static final String GET_PACKAGE_INFO = "getPackageInfo";
    private static final int GET_SIGNATURES_FLAG = 64;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_PACKAGE_INFO);
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        JavaParser.TypeDescriptor firstParameterType;
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (!(resolved instanceof JavaParser.ResolvedMethod) || !((JavaParser.ResolvedMethod)resolved).getContainingClass().isSubclassOf(PACKAGE_MANAGER_CLASS, false)) {
            return;
        }
        StrictListAccessor argumentList = node.astArguments();
        if (argumentList != null && argumentList.size() == 2 && (firstParameterType = context.getType(argumentList.first())) != null && firstParameterType.matchesSignature("java.lang.String")) {
            GetSignaturesDetector.maybeReportIssue(GetSignaturesDetector.calculateValue(context, (Expression)argumentList.last()), context, node);
        }
    }

    private static void maybeReportIssue(int flagValue, JavaContext context, MethodInvocation node) {
        if ((flagValue & 0x40) != 0) {
            context.report(ISSUE, (Node)node, context.getLocation(node.astArguments().last()), "Reading app signatures from getPackageInfo: The app signatures could be exploited if not validated properly; see issue explanation for details.");
        }
    }

    private static int calculateValue(JavaContext context, Expression expression) {
        Object value;
        if (expression instanceof IntegralLiteral) {
            return ((IntegralLiteral)expression).astIntValue();
        }
        JavaParser.ResolvedNode resolvedNode = context.resolve((Node)expression);
        if (resolvedNode instanceof JavaParser.ResolvedField && (value = ((JavaParser.ResolvedField)resolvedNode).getValue()) instanceof Integer) {
            return (Integer)value;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            BinaryOperator operator = binaryExpression.astOperator();
            int leftValue = GetSignaturesDetector.calculateValue(context, binaryExpression.astLeft());
            int rightValue = GetSignaturesDetector.calculateValue(context, binaryExpression.astRight());
            if (operator == BinaryOperator.BITWISE_OR) {
                return leftValue | rightValue;
            }
            if (operator == BinaryOperator.BITWISE_AND) {
                return leftValue & rightValue;
            }
            if (operator == BinaryOperator.BITWISE_XOR) {
                return leftValue ^ rightValue;
            }
        }
        return 0;
    }

    private static boolean isStringParameter(@NonNull Expression expression, @NonNull JavaContext context) {
        if (expression instanceof StringLiteral) {
            return true;
        }
        JavaParser.ResolvedNode resolvedNode = context.resolve((Node)expression);
        return resolvedNode instanceof JavaParser.ResolvedField && ((JavaParser.ResolvedField)resolvedNode).getValue() instanceof String;
    }
}

