/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import org.w3c.dom.Element;

public class PreferenceActivityDetector
extends Detector
implements Detector.XmlScanner,
Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"ExportedPreferenceActivity", (String)"PreferenceActivity should not be exported", (String)"Checks that PreferenceActivity and its subclasses are never exported", (String)"Fragment injection gives anyone who can send your PreferenceActivity an intent the ability to load any fragment, with any arguments, in your process.", (Category)Category.SECURITY, (int)8, (Severity)Severity.WARNING, (Implementation)new Implementation(PreferenceActivityDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE))).addMoreInfo("http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection");
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    private final Map<String, Location.Handle> mExportedActivities = new HashMap<String, Location.Handle>();

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("activity");
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String fqcn;
        if (SecurityDetector.getExported(element) && (fqcn = PreferenceActivityDetector.getFqcn(element)) != null) {
            if (fqcn.equals(PREFERENCE_ACTIVITY) && !context.getDriver().isSuppressed(context, ISSUE, (org.w3c.dom.Node)element)) {
                String message = "PreferenceActivity should not be exported";
                context.report(ISSUE, context.getLocation((org.w3c.dom.Node)element), message, null);
            }
            this.mExportedActivities.put(fqcn, context.createLocationHandle((org.w3c.dom.Node)element));
        }
    }

    private static String getFqcn(@NonNull Element activityElement) {
        String activityClassName = activityElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (activityClassName == null || activityClassName.isEmpty()) {
            return null;
        }
        if (activityClassName.startsWith(".")) {
            String pkg = activityElement.getOwnerDocument().getDocumentElement().getAttribute("package");
            if (pkg != null) {
                return pkg + activityClassName;
            }
            return null;
        }
        return activityClassName;
    }

    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        if (!context.getProject().getReportIssues()) {
            return null;
        }
        return new PreferenceActivityVisitor(context);
    }

    private class PreferenceActivityVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public PreferenceActivityVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitClassDeclaration(ClassDeclaration node) {
            JavaParser.ResolvedNode resolvedNode = this.mContext.resolve((Node)node);
            if (!(resolvedNode instanceof JavaParser.ResolvedClass)) {
                return false;
            }
            JavaParser.ResolvedClass resolvedClass = (JavaParser.ResolvedClass)resolvedNode;
            String className = resolvedClass.getName();
            if (resolvedClass.isSubclassOf(PreferenceActivityDetector.PREFERENCE_ACTIVITY, false) && PreferenceActivityDetector.this.mExportedActivities.containsKey(className)) {
                if (this.mContext.getMainProject().getTargetSdk() >= 19 && this.overridesIsValidFragment(resolvedClass)) {
                    return false;
                }
                String message = String.format("PreferenceActivity subclass %1$s should not be exported", className);
                this.mContext.report(ISSUE, ((Location.Handle)PreferenceActivityDetector.this.mExportedActivities.get(className)).resolve(), message, null);
            }
            return true;
        }

        private boolean overridesIsValidFragment(JavaParser.ResolvedClass resolvedClass) {
            Iterable resolvedMethods = resolvedClass.getMethods(PreferenceActivityDetector.IS_VALID_FRAGMENT);
            for (JavaParser.ResolvedMethod resolvedMethod : resolvedMethods) {
                if (resolvedMethod.getArgumentCount() != 1 || !resolvedMethod.getArgumentType(0).getName().equals("java.lang.String")) continue;
                return true;
            }
            return false;
        }
    }
}

