/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.PluralsDatabase;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluralsDetector
extends ResourceXmlDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(PluralsDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue MISSING = Issue.create((String)"MissingQuantity", (String)"Missing quantity translation", (String)"Checks for missing quantity strings relevant to each locale", (String)"Different languages have different rules for grammatical agreement with quantity. In English, for example, the quantity 1 is a special case. We write \"1 book\", but for any other quantity we'd write \"n books\". This distinction between singular and plural is very common, but other languages make finer distinctions.\n\nThis lint check looks at each translation of a `<plural>` and makes sure that all the quantity strings considered by the given language are provided by this translation.\n\nFor example, an English translation must provide a string for `quantity=\"one\"`. Similarly, a Czech translation must provide a string for `quantity=\"few\"`.", (Category)Category.MESSAGES, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
    public static final Issue EXTRA = Issue.create((String)"UnusedQuantity", (String)"Unused quantity translations", (String)"Checks for quantity string translations which are not used in this language", (String)"Android defines a number of different quantity strings, such as `zero`, `one`, `few` and `many`. However, many languages do not distinguish grammatically between all these different quantities.\n\nThis lint check looks at the quantity strings defined for each translation and flags any quantity strings that are unused (because the language does not make that quantity distinction, and Android will therefore not look it up.).\nFor example, in Chinese, only the `other` quantity is used, so even if you provide translations for `zero` and `one`, these strings will *not* be returned when `getQuantityString()` is called, even with `0` or `1`.", (Category)Category.MESSAGES, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
    public static final Issue IMPLIED_QUANTITY = Issue.create((String)"ImpliedQuantity", (String)"Implied Quantities", (String)"Looks for quantity string translations which do not include the quantity", (String)"Plural strings should generally include a `%s` or `%d` formatting argument. In locales like English, the `one` quantity only applies to a single value, 1, but that's not true everywhere. For example, in Slovene, the `one` quantity will apply to 1, 101, 201, 301, and so on. Similarly, there are locales where multiple values match the `zero` and `two` quantities.\n\nIn these locales, it is usually an error to have a message which does not include a formatting argument (such as '%d'), since it will not be clear from the grammar what quantity the quantity string is describing.", (Category)Category.MESSAGES, (int)5, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/resources/string-resource.html#Plurals");

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("plurals");
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        int count = LintUtils.getChildCount((Node)element);
        if (count == 0) {
            context.report(MISSING, (Node)element, context.getLocation((Node)element), "There should be at least one quantity string in this <plural> definition", null);
            return;
        }
        Pair<String, String> locale = TypoDetector.getLocale(context);
        if (locale == null) {
            return;
        }
        String language = (String)locale.getFirst();
        if (language == null) {
            return;
        }
        PluralsDatabase plurals = PluralsDatabase.get();
        EnumSet<PluralsDatabase.Quantity> relevant = plurals.getRelevant(language);
        if (relevant == null) {
            return;
        }
        EnumSet<PluralsDatabase.Quantity> defined = EnumSet.noneOf(PluralsDatabase.Quantity.class);
        NodeList children = element.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            PluralsDatabase.Quantity quantity;
            String quantityString;
            Element child;
            Node noe = children.item(i);
            if (noe.getNodeType() != 1 || !"item".equals((child = (Element)noe).getTagName()) || (quantityString = child.getAttribute("quantity")) == null || quantityString.isEmpty() || (quantity = PluralsDatabase.Quantity.get(quantityString)) == null || quantity == PluralsDatabase.Quantity.other) continue;
            defined.add(quantity);
            if (!plurals.hasMultipleValuesForQuantity(language, quantity) || PluralsDetector.haveFormattingParameter(child) || !context.isEnabled(IMPLIED_QUANTITY)) continue;
            String example = plurals.findIntegerExamples(language, quantity);
            String append = example == null ? "" : " (" + example + ")";
            String message = String.format("The quantity '%1$s' matches more than one specific number in this locale%2$s, but the message did not include a formatting argument (such as %%d). This is usually an internationalization error. See full issue explanation for more.", new Object[]{quantity, append});
            context.report(IMPLIED_QUANTITY, (Node)child, context.getLocation((Node)child), message, null);
        }
        if (relevant.equals(defined)) {
            return;
        }
        Object missing = relevant.clone();
        ((AbstractSet)missing).removeAll(defined);
        if (!((AbstractCollection)missing).isEmpty()) {
            String message = String.format("For locale %1$s the following quantities should also be defined: %2$s", TranslationDetector.getLanguageDescription(language), PluralsDatabase.Quantity.formatSet((EnumSet<PluralsDatabase.Quantity>)missing));
            context.report(MISSING, (Node)element, context.getLocation((Node)element), message, null);
        }
        Object extra = defined.clone();
        ((AbstractSet)extra).removeAll(relevant);
        if (!((AbstractCollection)extra).isEmpty()) {
            String message = String.format("For language %1$s the following quantities are not relevant: %2$s", TranslationDetector.getLanguageDescription(language), PluralsDatabase.Quantity.formatSet((EnumSet<PluralsDatabase.Quantity>)extra));
            context.report(EXTRA, (Node)element, context.getLocation((Node)element), message, null);
        }
    }

    private static boolean haveFormattingParameter(@NonNull Element element) {
        NodeList children = element.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String text;
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            if (!(nodeType == 1 ? PluralsDetector.haveFormattingParameter((Element)child) : nodeType == 3 && (text = child.getNodeValue()).indexOf(37) != -1 && StringFormatDetector.getFormatArgumentCount(text, null) >= 1)) continue;
            return true;
        }
        return false;
    }
}

