/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(NamespaceDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue TYPO = Issue.create((String)"NamespaceTypo", (String)"Misspelled namespace declaration", (String)"Looks for misspellings in namespace declarations", (String)"Accidental misspellings in namespace declarations can lead to some very obscure error messages. This check looks for potential misspellings to help track these down.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue UNUSED = Issue.create((String)"UnusedNamespace", (String)"Unused namespace", (String)"Finds unused namespaces in XML documents", (String)"Unused namespace declarations take up space and require processing that is not necessary", (Category)Category.PERFORMANCE, (int)1, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue CUSTOM_VIEW = Issue.create((String)"LibraryCustomView", (String)"Custom views in libraries should use res-auto-namespace", (String)"Flags custom attributes in libraries, which must use the res-auto-namespace instead", (String)"When using a custom view with custom attributes in a library project, the layout must use the special namespace http://schemas.android.com/apk/res-auto instead of a URI which includes the library project's own package. This will be used to automatically adjust the namespace of the attributes when the library resources are merged into the application project.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue RES_AUTO = Issue.create((String)"ResAuto", (String)"Hardcoded Package in Namespace", (String)"Finds resource namespaces with hardcoded package names", (String)"In Gradle projects, the actual package used in the final APK can vary; for you can add a `.debug` package suffix in one version and not the other. Therefore, you should *not* hardcode the application package in the resource; instead, use the special namespace `http://schemas.android.com/apk/res-auto` which will cause the tools to figure out the right namespace for the resource regardless of the actual package used during the build.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    private static final String XMLNS_ANDROID = "xmlns:android";
    private static final String XMLNS_A = "xmlns:a";
    private Map<String, Attr> mUnusedNamespaces;
    private boolean mCheckUnused;

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(@NonNull XmlContext context, @NonNull Document document) {
        boolean haveCustomNamespace = false;
        Element root = document.getDocumentElement();
        NamedNodeMap attributes = root.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String value;
            Node item = attributes.item(i);
            if (!item.getNodeName().startsWith("xmlns:") || (value = item.getNodeValue()).equals("http://schemas.android.com/apk/res/android")) continue;
            Attr attribute = (Attr)item;
            if (value.startsWith("http://schemas.android.com/apk/res/")) {
                haveCustomNamespace = true;
                if (this.mUnusedNamespaces == null) {
                    this.mUnusedNamespaces = new HashMap<String, Attr>();
                }
                this.mUnusedNamespaces.put(item.getNodeName().substring("xmlns:".length()), attribute);
            } else {
                if (value.startsWith("urn:")) continue;
                if (!value.startsWith("http://")) {
                    if (!context.isEnabled(TYPO)) continue;
                    context.report(TYPO, (Node)attribute, context.getLocation((Node)attribute), "Suspicious namespace: should start with http://", null);
                    continue;
                }
                if (!value.equals("http://schemas.android.com/apk/res-auto") && value.contains("auto") && value.startsWith("http://schemas.android.com/")) {
                    context.report(RES_AUTO, (Node)attribute, context.getLocation((Node)attribute), "Suspicious namespace: Did you mean http://schemas.android.com/apk/res-auto", null);
                }
            }
            if (!context.isEnabled(TYPO)) continue;
            String name = attribute.getName();
            if (!name.equals(XMLNS_ANDROID) && !name.equals(XMLNS_A)) {
                String urlPrefix;
                int resIndex = value.indexOf("/res/");
                if (resIndex == -1 || value.length() + 5 <= "http://schemas.android.com/apk/res/".length() || (urlPrefix = value.substring(0, resIndex + 5)).equals("http://schemas.android.com/apk/res/") || LintUtils.editDistance((String)"http://schemas.android.com/apk/res/", (String)urlPrefix) > 3) continue;
                String correctUri = "http://schemas.android.com/apk/res/" + value.substring(resIndex + 5);
                context.report(TYPO, (Node)attribute, context.getLocation((Node)attribute), String.format("Possible typo in URL: was \"%1$s\", should probably be \"%2$s\"", value, correctUri), null);
                continue;
            }
            if (name.equals(XMLNS_A) && LintUtils.editDistance((String)"http://schemas.android.com/apk/res/android", (String)value) > 4) continue;
            if (value.equalsIgnoreCase("http://schemas.android.com/apk/res/android")) {
                context.report(TYPO, (Node)attribute, context.getLocation((Node)attribute), String.format("URI is case sensitive: was \"%1$s\", expected \"%2$s\"", value, "http://schemas.android.com/apk/res/android"), null);
                continue;
            }
            context.report(TYPO, (Node)attribute, context.getLocation((Node)attribute), String.format("Unexpected namespace URI bound to the \"android\" prefix, was %1$s, expected %2$s", value, "http://schemas.android.com/apk/res/android"), null);
        }
        if (haveCustomNamespace) {
            Project project = context.getProject();
            boolean checkCustomAttrs = context.isEnabled(CUSTOM_VIEW) && project.isLibrary() || context.isEnabled(RES_AUTO) && project.isGradleProject();
            this.mCheckUnused = context.isEnabled(UNUSED);
            if (checkCustomAttrs) {
                NamespaceDetector.checkCustomNamespace(context, root);
            }
            this.checkElement(context, root);
            if (this.mCheckUnused && !this.mUnusedNamespaces.isEmpty()) {
                for (Map.Entry<String, Attr> entry : this.mUnusedNamespaces.entrySet()) {
                    String prefix = entry.getKey();
                    Attr attribute = entry.getValue();
                    context.report(UNUSED, (Node)attribute, context.getLocation((Node)attribute), String.format("Unused namespace %1$s", prefix), null);
                }
            }
        }
    }

    private static void checkCustomNamespace(XmlContext context, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String uri;
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getName().startsWith("xmlns:") || (uri = attribute.getValue()) == null || uri.isEmpty() || !uri.startsWith("http://schemas.android.com/apk/res/") || uri.equals("http://schemas.android.com/apk/res/android")) continue;
            if (context.getProject().isGradleProject()) {
                context.report(RES_AUTO, (Node)attribute, context.getLocation((Node)attribute), "In Gradle projects, always use http://schemas.android.com/apk/res-auto for custom attributes", null);
                continue;
            }
            context.report(CUSTOM_VIEW, (Node)attribute, context.getLocation((Node)attribute), "When using a custom namespace attribute in a library project, use the namespace \"http://schemas.android.com/apk/res-auto\" instead.", null);
        }
    }

    private void checkElement(XmlContext context, Node node) {
        if (node.getNodeType() == 1) {
            int i;
            int n;
            if (this.mCheckUnused) {
                NamedNodeMap attributes = node.getAttributes();
                n = attributes.getLength();
                for (i = 0; i < n; ++i) {
                    Attr attribute = (Attr)attributes.item(i);
                    String prefix = attribute.getPrefix();
                    if (prefix == null) continue;
                    this.mUnusedNamespaces.remove(prefix);
                }
            }
            NodeList childNodes = node.getChildNodes();
            n = childNodes.getLength();
            for (i = 0; i < n; ++i) {
                this.checkElement(context, childNodes.item(i));
            }
        }
    }
}

