/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.Statement;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;

public class AlternateConstructorInvocation
extends AbstractNode
implements Statement {
    ListAccessor<TypeReference, AlternateConstructorInvocation> constructorTypeArguments = ListAccessor.of(this, TypeReference.class, "AlternateConstructorInvocation.constructorTypeArguments");
    ListAccessor<Expression, AlternateConstructorInvocation> arguments = ListAccessor.of(this, Expression.class, "AlternateConstructorInvocation.arguments");

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public RawListAccessor<TypeReference, AlternateConstructorInvocation> rawConstructorTypeArguments() {
        return this.constructorTypeArguments.asRaw();
    }

    public StrictListAccessor<TypeReference, AlternateConstructorInvocation> astConstructorTypeArguments() {
        return this.constructorTypeArguments.asStrict();
    }

    public RawListAccessor<Expression, AlternateConstructorInvocation> rawArguments() {
        return this.arguments.asRaw();
    }

    public StrictListAccessor<Expression, AlternateConstructorInvocation> astArguments() {
        return this.arguments.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.constructorTypeArguments.backingList());
        result.addAll(this.arguments.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.rawConstructorTypeArguments().replace(original, replacement)) {
            return true;
        }
        return this.rawArguments().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.rawConstructorTypeArguments().remove(child)) {
            return true;
        }
        return this.rawArguments().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitAlternateConstructorInvocation(this)) {
            return;
        }
        for (AbstractNode child : this.constructorTypeArguments.asIterable()) {
            child.accept(visitor);
        }
        for (AbstractNode child : this.arguments.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public AlternateConstructorInvocation copy() {
        AlternateConstructorInvocation result = new AlternateConstructorInvocation();
        for (AbstractNode n : this.constructorTypeArguments.backingList()) {
            result.rawConstructorTypeArguments().addToEnd(n == null ? null : n.copy());
        }
        for (AbstractNode n : this.arguments.backingList()) {
            result.rawArguments().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }
}

