/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import lombok.ast.libs.org.parboiled.asm.Label;
import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.commons.EmptyVisitor;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.FieldNode;
import lombok.ast.libs.org.parboiled.asm.tree.VarInsnNode;
import lombok.ast.libs.org.parboiled.common.Base64;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.transform.InstructionGraphNode;
import lombok.ast.libs.org.parboiled.transform.InstructionGroup;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import org.jetbrains.annotations.NotNull;

class InstructionGroupPreparer
implements Opcodes,
RuleMethodProcessor {
    private static final Object lock = new Object();
    private static final Base64 CUSTOM_BASE64 = new Base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789\u00e4\u00f6_");
    private RuleMethod method;

    InstructionGroupPreparer() {
    }

    public boolean appliesTo(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.InstructionGroupPreparer.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.InstructionGroupPreparer.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        return method.containsExplicitActions() || method.containsCaptures() || method.containsVars();
    }

    public void process(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.InstructionGroupPreparer.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.InstructionGroupPreparer.process(...) corresponds to @NotNull parameter and must not be null");
        }
        this.method = method;
        for (InstructionGroup group : method.getGroups()) {
            this.extractInstructions(group);
            this.extractFields(group);
            this.name(group, classNode);
        }
    }

    private void extractInstructions(InstructionGroup group) {
        for (InstructionGraphNode node : group.getNodes()) {
            if (node == group.getRoot()) continue;
            AbstractInsnNode insn = node.getInstruction();
            this.method.instructions.remove(insn);
            group.getInstructions().add(insn);
        }
    }

    private void extractFields(InstructionGroup group) {
        List<FieldNode> fields = group.getFields();
        for (InstructionGraphNode node : group.getNodes()) {
            int index;
            if (!node.isXLoad()) continue;
            VarInsnNode insn = (VarInsnNode)node.getInstruction();
            for (index = 0; index < fields.size() && fields.get((int)index).access != insn.var; ++index) {
            }
            if (index == fields.size()) {
                Type type = node.getResultValue().getType();
                fields.add(new FieldNode(insn.var, "field$" + index, type.getDescriptor(), null, type));
            }
            insn.var = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void name(InstructionGroup group, ParserClassNode classNode) {
        Object object = lock;
        synchronized (object) {
            MD5Digester digester = new MD5Digester(classNode.name);
            group.getInstructions().accept(digester);
            byte[] hash = digester.getMD5Hash();
            byte[] hash96 = new byte[12];
            System.arraycopy(hash, 0, hash96, 0, 12);
            String name = group.getRoot().isActionRoot() ? "Action$" : (group.getRoot().isCaptureRoot() ? "Capture$" : "VarInit$");
            name = name + CUSTOM_BASE64.encodeToString(hash96, false);
            group.setName(name);
        }
    }

    private static class MD5Digester
    extends EmptyVisitor {
        private static MessageDigest digest;
        private static ByteBuffer buffer;
        private final List<Label> labels = new ArrayList<Label>();
        private final String parserClassName;

        public MD5Digester(String parserClassName) {
            this.parserClassName = parserClassName;
            if (digest == null) {
                try {
                    digest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            if (buffer == null) {
                buffer = ByteBuffer.allocateDirect(4096);
            }
            buffer.clear();
        }

        public void visitInsn(int opcode) {
            this.update(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.update(opcode);
            this.update(operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.update(opcode);
            this.update(var);
            if (opcode == 25 && var == 0) {
                this.update(this.parserClassName);
            }
        }

        public void visitTypeInsn(int opcode, String type) {
            this.update(opcode);
            this.update(type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.update(opcode);
            this.update(owner);
            this.update(name);
            this.update(desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.update(opcode);
            this.update(owner);
            this.update(name);
            this.update(desc);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.update(opcode);
            this.update(label);
        }

        public void visitLabel(Label label) {
            this.update(label);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof String) {
                this.update((String)cst);
            } else if (cst instanceof Integer) {
                this.update((Integer)cst);
            } else if (cst instanceof Float) {
                this.ensureRemaining(4);
                buffer.putFloat(((Float)cst).floatValue());
            } else if (cst instanceof Long) {
                this.ensureRemaining(8);
                buffer.putLong((Long)cst);
            } else if (cst instanceof Double) {
                this.ensureRemaining(8);
                buffer.putDouble((Double)cst);
            } else {
                Preconditions.checkState(cst instanceof Type);
                this.update(((Type)cst).getInternalName());
            }
        }

        public void visitIincInsn(int var, int increment) {
            this.update(var);
            this.update(increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            this.update(min);
            this.update(max);
            this.update(dflt);
            for (Label label : labels) {
                this.update(label);
            }
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.update(dflt);
            for (int i = 0; i < keys.length; ++i) {
                this.update(keys[i]);
                this.update(labels[i]);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.update(desc);
            this.update(dims);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.update(start);
            this.update(end);
            this.update(handler);
            this.update(type);
        }

        private void update(int i) {
            this.ensureRemaining(4);
            buffer.putInt(i);
        }

        private void update(String str) {
            if (StringUtils.isNotEmpty(str)) {
                int len = str.length();
                this.ensureRemaining(len * 2);
                for (int i = 0; i < len; ++i) {
                    buffer.putChar(str.charAt(i));
                }
            }
        }

        private void update(Label label) {
            int index = this.labels.indexOf(label);
            if (index == -1) {
                index = this.labels.size();
                this.labels.add(label);
            }
            this.update(index);
        }

        private void ensureRemaining(int bytes) {
            if (buffer.remaining() < bytes) {
                this.digest();
            }
        }

        private void digest() {
            buffer.flip();
            digest.update(buffer);
            buffer.clear();
        }

        public byte[] getMD5Hash() {
            this.digest();
            return digest.digest();
        }
    }
}

