/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBSnapshotTenantDatabasesRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBSnapshotTenantDatabasesRequestMarshaller
implements Marshaller<Request<DescribeDBSnapshotTenantDatabasesRequest>, DescribeDBSnapshotTenantDatabasesRequest> {
    public Request<DescribeDBSnapshotTenantDatabasesRequest> marshall(DescribeDBSnapshotTenantDatabasesRequest describeDBSnapshotTenantDatabasesRequest) {
        if (describeDBSnapshotTenantDatabasesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBSnapshotTenantDatabasesRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBSnapshotTenantDatabases");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBSnapshotTenantDatabasesRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)describeDBSnapshotTenantDatabasesRequest.getDBInstanceIdentifier()));
        }
        if (describeDBSnapshotTenantDatabasesRequest.getDBSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString((String)describeDBSnapshotTenantDatabasesRequest.getDBSnapshotIdentifier()));
        }
        if (describeDBSnapshotTenantDatabasesRequest.getSnapshotType() != null) {
            request.addParameter("SnapshotType", StringUtils.fromString((String)describeDBSnapshotTenantDatabasesRequest.getSnapshotType()));
        }
        if (!describeDBSnapshotTenantDatabasesRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBSnapshotTenantDatabasesRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBSnapshotTenantDatabasesRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBSnapshotTenantDatabasesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBSnapshotTenantDatabasesRequest.getMaxRecords()));
        }
        if (describeDBSnapshotTenantDatabasesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBSnapshotTenantDatabasesRequest.getMarker()));
        }
        if (describeDBSnapshotTenantDatabasesRequest.getDbiResourceId() != null) {
            request.addParameter("DbiResourceId", StringUtils.fromString((String)describeDBSnapshotTenantDatabasesRequest.getDbiResourceId()));
        }
        return request;
    }
}

