/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.rds.model.IntegrationError;
import com.amazonaws.services.rds.model.IntegrationStatus;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Integration
implements Serializable,
Cloneable {
    private String sourceArn;
    private String targetArn;
    private String integrationName;
    private String integrationArn;
    private String kMSKeyId;
    private SdkInternalMap<String, String> additionalEncryptionContext;
    private String status;
    private SdkInternalList<Tag> tags;
    private Date createTime;
    private SdkInternalList<IntegrationError> errors;
    private String dataFilter;
    private String description;

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public Integration withSourceArn(String sourceArn) {
        this.setSourceArn(sourceArn);
        return this;
    }

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public Integration withTargetArn(String targetArn) {
        this.setTargetArn(targetArn);
        return this;
    }

    public void setIntegrationName(String integrationName) {
        this.integrationName = integrationName;
    }

    public String getIntegrationName() {
        return this.integrationName;
    }

    public Integration withIntegrationName(String integrationName) {
        this.setIntegrationName(integrationName);
        return this;
    }

    public void setIntegrationArn(String integrationArn) {
        this.integrationArn = integrationArn;
    }

    public String getIntegrationArn() {
        return this.integrationArn;
    }

    public Integration withIntegrationArn(String integrationArn) {
        this.setIntegrationArn(integrationArn);
        return this;
    }

    public void setKMSKeyId(String kMSKeyId) {
        this.kMSKeyId = kMSKeyId;
    }

    public String getKMSKeyId() {
        return this.kMSKeyId;
    }

    public Integration withKMSKeyId(String kMSKeyId) {
        this.setKMSKeyId(kMSKeyId);
        return this;
    }

    public Map<String, String> getAdditionalEncryptionContext() {
        if (this.additionalEncryptionContext == null) {
            this.additionalEncryptionContext = new SdkInternalMap();
        }
        return this.additionalEncryptionContext;
    }

    public void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.additionalEncryptionContext = additionalEncryptionContext == null ? null : new SdkInternalMap(additionalEncryptionContext);
    }

    public Integration withAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.setAdditionalEncryptionContext(additionalEncryptionContext);
        return this;
    }

    public Integration addAdditionalEncryptionContextEntry(String key, String value) {
        if (null == this.additionalEncryptionContext) {
            this.additionalEncryptionContext = new SdkInternalMap();
        }
        if (this.additionalEncryptionContext.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalEncryptionContext.put((Object)key, (Object)value);
        return this;
    }

    public Integration clearAdditionalEncryptionContextEntries() {
        this.additionalEncryptionContext = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Integration withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Integration withStatus(IntegrationStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public Integration withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public Integration withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Integration withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public List<IntegrationError> getErrors() {
        if (this.errors == null) {
            this.errors = new SdkInternalList();
        }
        return this.errors;
    }

    public void setErrors(Collection<IntegrationError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new SdkInternalList(errors);
    }

    public Integration withErrors(IntegrationError ... errors) {
        if (this.errors == null) {
            this.setErrors((Collection<IntegrationError>)new SdkInternalList(errors.length));
        }
        for (IntegrationError ele : errors) {
            this.errors.add((Object)ele);
        }
        return this;
    }

    public Integration withErrors(Collection<IntegrationError> errors) {
        this.setErrors(errors);
        return this;
    }

    public void setDataFilter(String dataFilter) {
        this.dataFilter = dataFilter;
    }

    public String getDataFilter() {
        return this.dataFilter;
    }

    public Integration withDataFilter(String dataFilter) {
        this.setDataFilter(dataFilter);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Integration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceArn() != null) {
            sb.append("SourceArn: ").append(this.getSourceArn()).append(",");
        }
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: ").append(this.getTargetArn()).append(",");
        }
        if (this.getIntegrationName() != null) {
            sb.append("IntegrationName: ").append(this.getIntegrationName()).append(",");
        }
        if (this.getIntegrationArn() != null) {
            sb.append("IntegrationArn: ").append(this.getIntegrationArn()).append(",");
        }
        if (this.getKMSKeyId() != null) {
            sb.append("KMSKeyId: ").append(this.getKMSKeyId()).append(",");
        }
        if (this.getAdditionalEncryptionContext() != null) {
            sb.append("AdditionalEncryptionContext: ").append(this.getAdditionalEncryptionContext()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors()).append(",");
        }
        if (this.getDataFilter() != null) {
            sb.append("DataFilter: ").append(this.getDataFilter()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Integration)) {
            return false;
        }
        Integration other = (Integration)obj;
        if (other.getSourceArn() == null ^ this.getSourceArn() == null) {
            return false;
        }
        if (other.getSourceArn() != null && !other.getSourceArn().equals(this.getSourceArn())) {
            return false;
        }
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getIntegrationName() == null ^ this.getIntegrationName() == null) {
            return false;
        }
        if (other.getIntegrationName() != null && !other.getIntegrationName().equals(this.getIntegrationName())) {
            return false;
        }
        if (other.getIntegrationArn() == null ^ this.getIntegrationArn() == null) {
            return false;
        }
        if (other.getIntegrationArn() != null && !other.getIntegrationArn().equals(this.getIntegrationArn())) {
            return false;
        }
        if (other.getKMSKeyId() == null ^ this.getKMSKeyId() == null) {
            return false;
        }
        if (other.getKMSKeyId() != null && !other.getKMSKeyId().equals(this.getKMSKeyId())) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() == null ^ this.getAdditionalEncryptionContext() == null) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() != null && !other.getAdditionalEncryptionContext().equals(this.getAdditionalEncryptionContext())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        if (other.getErrors() != null && !other.getErrors().equals(this.getErrors())) {
            return false;
        }
        if (other.getDataFilter() == null ^ this.getDataFilter() == null) {
            return false;
        }
        if (other.getDataFilter() != null && !other.getDataFilter().equals(this.getDataFilter())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceArn() == null ? 0 : this.getSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationName() == null ? 0 : this.getIntegrationName().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationArn() == null ? 0 : this.getIntegrationArn().hashCode());
        hashCode = 31 * hashCode + (this.getKMSKeyId() == null ? 0 : this.getKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalEncryptionContext() == null ? 0 : this.getAdditionalEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        hashCode = 31 * hashCode + (this.getDataFilter() == null ? 0 : this.getDataFilter().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public Integration clone() {
        try {
            return (Integration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

