/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.rds.model.BacktrackDBClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class BacktrackDBClusterRequestMarshaller
implements Marshaller<Request<BacktrackDBClusterRequest>, BacktrackDBClusterRequest> {
    public Request<BacktrackDBClusterRequest> marshall(BacktrackDBClusterRequest backtrackDBClusterRequest) {
        if (backtrackDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)backtrackDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "BacktrackDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (backtrackDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)backtrackDBClusterRequest.getDBClusterIdentifier()));
        }
        if (backtrackDBClusterRequest.getBacktrackTo() != null) {
            request.addParameter("BacktrackTo", StringUtils.fromDate((Date)backtrackDBClusterRequest.getBacktrackTo()));
        }
        if (backtrackDBClusterRequest.getForce() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)backtrackDBClusterRequest.getForce()));
        }
        if (backtrackDBClusterRequest.getUseEarliestTimeOnPointInTimeUnavailable() != null) {
            request.addParameter("UseEarliestTimeOnPointInTimeUnavailable", StringUtils.fromBoolean((Boolean)backtrackDBClusterRequest.getUseEarliestTimeOnPointInTimeUnavailable()));
        }
        return request;
    }
}

