/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata;

import javax.annotation.Generated;

import com.amazonaws.services.neptunedata.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonNeptunedata}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonNeptunedata implements AmazonNeptunedata {

    protected AbstractAmazonNeptunedata() {
    }

    @Override
    public CancelGremlinQueryResult cancelGremlinQuery(CancelGremlinQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelLoaderJobResult cancelLoaderJob(CancelLoaderJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelMLDataProcessingJobResult cancelMLDataProcessingJob(CancelMLDataProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelMLModelTrainingJobResult cancelMLModelTrainingJob(CancelMLModelTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelMLModelTransformJobResult cancelMLModelTransformJob(CancelMLModelTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelOpenCypherQueryResult cancelOpenCypherQuery(CancelOpenCypherQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMLEndpointResult createMLEndpoint(CreateMLEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMLEndpointResult deleteMLEndpoint(DeleteMLEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePropertygraphStatisticsResult deletePropertygraphStatistics(DeletePropertygraphStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSparqlStatisticsResult deleteSparqlStatistics(DeleteSparqlStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExecuteFastResetResult executeFastReset(ExecuteFastResetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExecuteGremlinExplainQueryResult executeGremlinExplainQuery(ExecuteGremlinExplainQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExecuteGremlinProfileQueryResult executeGremlinProfileQuery(ExecuteGremlinProfileQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExecuteGremlinQueryResult executeGremlinQuery(ExecuteGremlinQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExecuteOpenCypherExplainQueryResult executeOpenCypherExplainQuery(ExecuteOpenCypherExplainQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEngineStatusResult getEngineStatus(GetEngineStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGremlinQueryStatusResult getGremlinQueryStatus(GetGremlinQueryStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMLDataProcessingJobResult getMLDataProcessingJob(GetMLDataProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMLEndpointResult getMLEndpoint(GetMLEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMLModelTrainingJobResult getMLModelTrainingJob(GetMLModelTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMLModelTransformJobResult getMLModelTransformJob(GetMLModelTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetOpenCypherQueryStatusResult getOpenCypherQueryStatus(GetOpenCypherQueryStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPropertygraphStatisticsResult getPropertygraphStatistics(GetPropertygraphStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPropertygraphSummaryResult getPropertygraphSummary(GetPropertygraphSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRDFGraphSummaryResult getRDFGraphSummary(GetRDFGraphSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSparqlStatisticsResult getSparqlStatistics(GetSparqlStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSparqlStreamResult getSparqlStream(GetSparqlStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGremlinQueriesResult listGremlinQueries(ListGremlinQueriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLoaderJobsResult listLoaderJobs(ListLoaderJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMLDataProcessingJobsResult listMLDataProcessingJobs(ListMLDataProcessingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMLEndpointsResult listMLEndpoints(ListMLEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMLModelTrainingJobsResult listMLModelTrainingJobs(ListMLModelTrainingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMLModelTransformJobsResult listMLModelTransformJobs(ListMLModelTransformJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOpenCypherQueriesResult listOpenCypherQueries(ListOpenCypherQueriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ManagePropertygraphStatisticsResult managePropertygraphStatistics(ManagePropertygraphStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ManageSparqlStatisticsResult manageSparqlStatistics(ManageSparqlStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartLoaderJobResult startLoaderJob(StartLoaderJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMLDataProcessingJobResult startMLDataProcessingJob(StartMLDataProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMLModelTrainingJobResult startMLModelTrainingJob(StartMLModelTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMLModelTransformJobResult startMLModelTransformJob(StartMLModelTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
