/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelbuilding.model.UtteranceData;
import com.amazonaws.services.lexmodelbuilding.model.transform.UtteranceListMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UtteranceList
implements Serializable,
Cloneable,
StructuredPojo {
    private String botVersion;
    private List<UtteranceData> utterances;

    public void setBotVersion(String botVersion) {
        this.botVersion = botVersion;
    }

    public String getBotVersion() {
        return this.botVersion;
    }

    public UtteranceList withBotVersion(String botVersion) {
        this.setBotVersion(botVersion);
        return this;
    }

    public List<UtteranceData> getUtterances() {
        return this.utterances;
    }

    public void setUtterances(Collection<UtteranceData> utterances) {
        if (utterances == null) {
            this.utterances = null;
            return;
        }
        this.utterances = new ArrayList<UtteranceData>(utterances);
    }

    public UtteranceList withUtterances(UtteranceData ... utterances) {
        if (this.utterances == null) {
            this.setUtterances(new ArrayList<UtteranceData>(utterances.length));
        }
        for (UtteranceData ele : utterances) {
            this.utterances.add(ele);
        }
        return this;
    }

    public UtteranceList withUtterances(Collection<UtteranceData> utterances) {
        this.setUtterances(utterances);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBotVersion() != null) {
            sb.append("BotVersion: ").append(this.getBotVersion()).append(",");
        }
        if (this.getUtterances() != null) {
            sb.append("Utterances: ").append(this.getUtterances());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceList)) {
            return false;
        }
        UtteranceList other = (UtteranceList)obj;
        if (other.getBotVersion() == null ^ this.getBotVersion() == null) {
            return false;
        }
        if (other.getBotVersion() != null && !other.getBotVersion().equals(this.getBotVersion())) {
            return false;
        }
        if (other.getUtterances() == null ^ this.getUtterances() == null) {
            return false;
        }
        return other.getUtterances() == null || other.getUtterances().equals(this.getUtterances());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBotVersion() == null ? 0 : this.getBotVersion().hashCode());
        hashCode = 31 * hashCode + (this.getUtterances() == null ? 0 : this.getUtterances().hashCode());
        return hashCode;
    }

    public UtteranceList clone() {
        try {
            return (UtteranceList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtteranceListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

