/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateVpcConnectionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String targetClusterArn;
    private String authentication;
    private String vpcId;
    private List<String> clientSubnets;
    private List<String> securityGroups;
    private Map<String, String> tags;

    public void setTargetClusterArn(String targetClusterArn) {
        this.targetClusterArn = targetClusterArn;
    }

    public String getTargetClusterArn() {
        return this.targetClusterArn;
    }

    public CreateVpcConnectionRequest withTargetClusterArn(String targetClusterArn) {
        this.setTargetClusterArn(targetClusterArn);
        return this;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public CreateVpcConnectionRequest withAuthentication(String authentication) {
        this.setAuthentication(authentication);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public CreateVpcConnectionRequest withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<String> getClientSubnets() {
        return this.clientSubnets;
    }

    public void setClientSubnets(Collection<String> clientSubnets) {
        if (clientSubnets == null) {
            this.clientSubnets = null;
            return;
        }
        this.clientSubnets = new ArrayList<String>(clientSubnets);
    }

    public CreateVpcConnectionRequest withClientSubnets(String ... clientSubnets) {
        if (this.clientSubnets == null) {
            this.setClientSubnets(new ArrayList<String>(clientSubnets.length));
        }
        for (String ele : clientSubnets) {
            this.clientSubnets.add(ele);
        }
        return this;
    }

    public CreateVpcConnectionRequest withClientSubnets(Collection<String> clientSubnets) {
        this.setClientSubnets(clientSubnets);
        return this;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<String>(securityGroups);
    }

    public CreateVpcConnectionRequest withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public CreateVpcConnectionRequest withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateVpcConnectionRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateVpcConnectionRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateVpcConnectionRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetClusterArn() != null) {
            sb.append("TargetClusterArn: ").append(this.getTargetClusterArn()).append(",");
        }
        if (this.getAuthentication() != null) {
            sb.append("Authentication: ").append(this.getAuthentication()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getClientSubnets() != null) {
            sb.append("ClientSubnets: ").append(this.getClientSubnets()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcConnectionRequest)) {
            return false;
        }
        CreateVpcConnectionRequest other = (CreateVpcConnectionRequest)obj;
        if (other.getTargetClusterArn() == null ^ this.getTargetClusterArn() == null) {
            return false;
        }
        if (other.getTargetClusterArn() != null && !other.getTargetClusterArn().equals(this.getTargetClusterArn())) {
            return false;
        }
        if (other.getAuthentication() == null ^ this.getAuthentication() == null) {
            return false;
        }
        if (other.getAuthentication() != null && !other.getAuthentication().equals(this.getAuthentication())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getClientSubnets() == null ^ this.getClientSubnets() == null) {
            return false;
        }
        if (other.getClientSubnets() != null && !other.getClientSubnets().equals(this.getClientSubnets())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetClusterArn() == null ? 0 : this.getTargetClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getAuthentication() == null ? 0 : this.getAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getClientSubnets() == null ? 0 : this.getClientSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateVpcConnectionRequest clone() {
        return (CreateVpcConnectionRequest)super.clone();
    }
}

