/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.inspector2.AWSInspector2Async;
import com.amazonaws.services.inspector2.AWSInspector2AsyncClientBuilder;
import com.amazonaws.services.inspector2.AWSInspector2Client;
import com.amazonaws.services.inspector2.model.AssociateMemberRequest;
import com.amazonaws.services.inspector2.model.AssociateMemberResult;
import com.amazonaws.services.inspector2.model.BatchGetAccountStatusRequest;
import com.amazonaws.services.inspector2.model.BatchGetAccountStatusResult;
import com.amazonaws.services.inspector2.model.BatchGetCodeSnippetRequest;
import com.amazonaws.services.inspector2.model.BatchGetCodeSnippetResult;
import com.amazonaws.services.inspector2.model.BatchGetFreeTrialInfoRequest;
import com.amazonaws.services.inspector2.model.BatchGetFreeTrialInfoResult;
import com.amazonaws.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest;
import com.amazonaws.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusResult;
import com.amazonaws.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest;
import com.amazonaws.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResult;
import com.amazonaws.services.inspector2.model.CancelFindingsReportRequest;
import com.amazonaws.services.inspector2.model.CancelFindingsReportResult;
import com.amazonaws.services.inspector2.model.CancelSbomExportRequest;
import com.amazonaws.services.inspector2.model.CancelSbomExportResult;
import com.amazonaws.services.inspector2.model.CreateFilterRequest;
import com.amazonaws.services.inspector2.model.CreateFilterResult;
import com.amazonaws.services.inspector2.model.CreateFindingsReportRequest;
import com.amazonaws.services.inspector2.model.CreateFindingsReportResult;
import com.amazonaws.services.inspector2.model.CreateSbomExportRequest;
import com.amazonaws.services.inspector2.model.CreateSbomExportResult;
import com.amazonaws.services.inspector2.model.DeleteFilterRequest;
import com.amazonaws.services.inspector2.model.DeleteFilterResult;
import com.amazonaws.services.inspector2.model.DescribeOrganizationConfigurationRequest;
import com.amazonaws.services.inspector2.model.DescribeOrganizationConfigurationResult;
import com.amazonaws.services.inspector2.model.DisableDelegatedAdminAccountRequest;
import com.amazonaws.services.inspector2.model.DisableDelegatedAdminAccountResult;
import com.amazonaws.services.inspector2.model.DisableRequest;
import com.amazonaws.services.inspector2.model.DisableResult;
import com.amazonaws.services.inspector2.model.DisassociateMemberRequest;
import com.amazonaws.services.inspector2.model.DisassociateMemberResult;
import com.amazonaws.services.inspector2.model.EnableDelegatedAdminAccountRequest;
import com.amazonaws.services.inspector2.model.EnableDelegatedAdminAccountResult;
import com.amazonaws.services.inspector2.model.EnableRequest;
import com.amazonaws.services.inspector2.model.EnableResult;
import com.amazonaws.services.inspector2.model.GetConfigurationRequest;
import com.amazonaws.services.inspector2.model.GetConfigurationResult;
import com.amazonaws.services.inspector2.model.GetDelegatedAdminAccountRequest;
import com.amazonaws.services.inspector2.model.GetDelegatedAdminAccountResult;
import com.amazonaws.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest;
import com.amazonaws.services.inspector2.model.GetEc2DeepInspectionConfigurationResult;
import com.amazonaws.services.inspector2.model.GetEncryptionKeyRequest;
import com.amazonaws.services.inspector2.model.GetEncryptionKeyResult;
import com.amazonaws.services.inspector2.model.GetFindingsReportStatusRequest;
import com.amazonaws.services.inspector2.model.GetFindingsReportStatusResult;
import com.amazonaws.services.inspector2.model.GetMemberRequest;
import com.amazonaws.services.inspector2.model.GetMemberResult;
import com.amazonaws.services.inspector2.model.GetSbomExportRequest;
import com.amazonaws.services.inspector2.model.GetSbomExportResult;
import com.amazonaws.services.inspector2.model.ListAccountPermissionsRequest;
import com.amazonaws.services.inspector2.model.ListAccountPermissionsResult;
import com.amazonaws.services.inspector2.model.ListCoverageRequest;
import com.amazonaws.services.inspector2.model.ListCoverageResult;
import com.amazonaws.services.inspector2.model.ListCoverageStatisticsRequest;
import com.amazonaws.services.inspector2.model.ListCoverageStatisticsResult;
import com.amazonaws.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import com.amazonaws.services.inspector2.model.ListDelegatedAdminAccountsResult;
import com.amazonaws.services.inspector2.model.ListFiltersRequest;
import com.amazonaws.services.inspector2.model.ListFiltersResult;
import com.amazonaws.services.inspector2.model.ListFindingAggregationsRequest;
import com.amazonaws.services.inspector2.model.ListFindingAggregationsResult;
import com.amazonaws.services.inspector2.model.ListFindingsRequest;
import com.amazonaws.services.inspector2.model.ListFindingsResult;
import com.amazonaws.services.inspector2.model.ListMembersRequest;
import com.amazonaws.services.inspector2.model.ListMembersResult;
import com.amazonaws.services.inspector2.model.ListTagsForResourceRequest;
import com.amazonaws.services.inspector2.model.ListTagsForResourceResult;
import com.amazonaws.services.inspector2.model.ListUsageTotalsRequest;
import com.amazonaws.services.inspector2.model.ListUsageTotalsResult;
import com.amazonaws.services.inspector2.model.ResetEncryptionKeyRequest;
import com.amazonaws.services.inspector2.model.ResetEncryptionKeyResult;
import com.amazonaws.services.inspector2.model.SearchVulnerabilitiesRequest;
import com.amazonaws.services.inspector2.model.SearchVulnerabilitiesResult;
import com.amazonaws.services.inspector2.model.TagResourceRequest;
import com.amazonaws.services.inspector2.model.TagResourceResult;
import com.amazonaws.services.inspector2.model.UntagResourceRequest;
import com.amazonaws.services.inspector2.model.UntagResourceResult;
import com.amazonaws.services.inspector2.model.UpdateConfigurationRequest;
import com.amazonaws.services.inspector2.model.UpdateConfigurationResult;
import com.amazonaws.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest;
import com.amazonaws.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResult;
import com.amazonaws.services.inspector2.model.UpdateEncryptionKeyRequest;
import com.amazonaws.services.inspector2.model.UpdateEncryptionKeyResult;
import com.amazonaws.services.inspector2.model.UpdateFilterRequest;
import com.amazonaws.services.inspector2.model.UpdateFilterResult;
import com.amazonaws.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest;
import com.amazonaws.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationResult;
import com.amazonaws.services.inspector2.model.UpdateOrganizationConfigurationRequest;
import com.amazonaws.services.inspector2.model.UpdateOrganizationConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSInspector2AsyncClient
extends AWSInspector2Client
implements AWSInspector2Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSInspector2AsyncClientBuilder asyncBuilder() {
        return AWSInspector2AsyncClientBuilder.standard();
    }

    AWSInspector2AsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSInspector2AsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateMemberResult> associateMemberAsync(AssociateMemberRequest request) {
        return this.associateMemberAsync(request, null);
    }

    @Override
    public Future<AssociateMemberResult> associateMemberAsync(AssociateMemberRequest request, final AsyncHandler<AssociateMemberRequest, AssociateMemberResult> asyncHandler) {
        final AssociateMemberRequest finalRequest = (AssociateMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateMemberResult>(){

            @Override
            public AssociateMemberResult call() throws Exception {
                AssociateMemberResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeAssociateMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetAccountStatusResult> batchGetAccountStatusAsync(BatchGetAccountStatusRequest request) {
        return this.batchGetAccountStatusAsync(request, null);
    }

    @Override
    public Future<BatchGetAccountStatusResult> batchGetAccountStatusAsync(BatchGetAccountStatusRequest request, final AsyncHandler<BatchGetAccountStatusRequest, BatchGetAccountStatusResult> asyncHandler) {
        final BatchGetAccountStatusRequest finalRequest = (BatchGetAccountStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetAccountStatusResult>(){

            @Override
            public BatchGetAccountStatusResult call() throws Exception {
                BatchGetAccountStatusResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeBatchGetAccountStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetCodeSnippetResult> batchGetCodeSnippetAsync(BatchGetCodeSnippetRequest request) {
        return this.batchGetCodeSnippetAsync(request, null);
    }

    @Override
    public Future<BatchGetCodeSnippetResult> batchGetCodeSnippetAsync(BatchGetCodeSnippetRequest request, final AsyncHandler<BatchGetCodeSnippetRequest, BatchGetCodeSnippetResult> asyncHandler) {
        final BatchGetCodeSnippetRequest finalRequest = (BatchGetCodeSnippetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetCodeSnippetResult>(){

            @Override
            public BatchGetCodeSnippetResult call() throws Exception {
                BatchGetCodeSnippetResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeBatchGetCodeSnippet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetFreeTrialInfoResult> batchGetFreeTrialInfoAsync(BatchGetFreeTrialInfoRequest request) {
        return this.batchGetFreeTrialInfoAsync(request, null);
    }

    @Override
    public Future<BatchGetFreeTrialInfoResult> batchGetFreeTrialInfoAsync(BatchGetFreeTrialInfoRequest request, final AsyncHandler<BatchGetFreeTrialInfoRequest, BatchGetFreeTrialInfoResult> asyncHandler) {
        final BatchGetFreeTrialInfoRequest finalRequest = (BatchGetFreeTrialInfoRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetFreeTrialInfoResult>(){

            @Override
            public BatchGetFreeTrialInfoResult call() throws Exception {
                BatchGetFreeTrialInfoResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeBatchGetFreeTrialInfo(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetMemberEc2DeepInspectionStatusResult> batchGetMemberEc2DeepInspectionStatusAsync(BatchGetMemberEc2DeepInspectionStatusRequest request) {
        return this.batchGetMemberEc2DeepInspectionStatusAsync(request, null);
    }

    @Override
    public Future<BatchGetMemberEc2DeepInspectionStatusResult> batchGetMemberEc2DeepInspectionStatusAsync(BatchGetMemberEc2DeepInspectionStatusRequest request, final AsyncHandler<BatchGetMemberEc2DeepInspectionStatusRequest, BatchGetMemberEc2DeepInspectionStatusResult> asyncHandler) {
        final BatchGetMemberEc2DeepInspectionStatusRequest finalRequest = (BatchGetMemberEc2DeepInspectionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetMemberEc2DeepInspectionStatusResult>(){

            @Override
            public BatchGetMemberEc2DeepInspectionStatusResult call() throws Exception {
                BatchGetMemberEc2DeepInspectionStatusResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeBatchGetMemberEc2DeepInspectionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchUpdateMemberEc2DeepInspectionStatusResult> batchUpdateMemberEc2DeepInspectionStatusAsync(BatchUpdateMemberEc2DeepInspectionStatusRequest request) {
        return this.batchUpdateMemberEc2DeepInspectionStatusAsync(request, null);
    }

    @Override
    public Future<BatchUpdateMemberEc2DeepInspectionStatusResult> batchUpdateMemberEc2DeepInspectionStatusAsync(BatchUpdateMemberEc2DeepInspectionStatusRequest request, final AsyncHandler<BatchUpdateMemberEc2DeepInspectionStatusRequest, BatchUpdateMemberEc2DeepInspectionStatusResult> asyncHandler) {
        final BatchUpdateMemberEc2DeepInspectionStatusRequest finalRequest = (BatchUpdateMemberEc2DeepInspectionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUpdateMemberEc2DeepInspectionStatusResult>(){

            @Override
            public BatchUpdateMemberEc2DeepInspectionStatusResult call() throws Exception {
                BatchUpdateMemberEc2DeepInspectionStatusResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeBatchUpdateMemberEc2DeepInspectionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelFindingsReportResult> cancelFindingsReportAsync(CancelFindingsReportRequest request) {
        return this.cancelFindingsReportAsync(request, null);
    }

    @Override
    public Future<CancelFindingsReportResult> cancelFindingsReportAsync(CancelFindingsReportRequest request, final AsyncHandler<CancelFindingsReportRequest, CancelFindingsReportResult> asyncHandler) {
        final CancelFindingsReportRequest finalRequest = (CancelFindingsReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelFindingsReportResult>(){

            @Override
            public CancelFindingsReportResult call() throws Exception {
                CancelFindingsReportResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeCancelFindingsReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelSbomExportResult> cancelSbomExportAsync(CancelSbomExportRequest request) {
        return this.cancelSbomExportAsync(request, null);
    }

    @Override
    public Future<CancelSbomExportResult> cancelSbomExportAsync(CancelSbomExportRequest request, final AsyncHandler<CancelSbomExportRequest, CancelSbomExportResult> asyncHandler) {
        final CancelSbomExportRequest finalRequest = (CancelSbomExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelSbomExportResult>(){

            @Override
            public CancelSbomExportResult call() throws Exception {
                CancelSbomExportResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeCancelSbomExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFilterResult> createFilterAsync(CreateFilterRequest request) {
        return this.createFilterAsync(request, null);
    }

    @Override
    public Future<CreateFilterResult> createFilterAsync(CreateFilterRequest request, final AsyncHandler<CreateFilterRequest, CreateFilterResult> asyncHandler) {
        final CreateFilterRequest finalRequest = (CreateFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFilterResult>(){

            @Override
            public CreateFilterResult call() throws Exception {
                CreateFilterResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeCreateFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFindingsReportResult> createFindingsReportAsync(CreateFindingsReportRequest request) {
        return this.createFindingsReportAsync(request, null);
    }

    @Override
    public Future<CreateFindingsReportResult> createFindingsReportAsync(CreateFindingsReportRequest request, final AsyncHandler<CreateFindingsReportRequest, CreateFindingsReportResult> asyncHandler) {
        final CreateFindingsReportRequest finalRequest = (CreateFindingsReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFindingsReportResult>(){

            @Override
            public CreateFindingsReportResult call() throws Exception {
                CreateFindingsReportResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeCreateFindingsReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSbomExportResult> createSbomExportAsync(CreateSbomExportRequest request) {
        return this.createSbomExportAsync(request, null);
    }

    @Override
    public Future<CreateSbomExportResult> createSbomExportAsync(CreateSbomExportRequest request, final AsyncHandler<CreateSbomExportRequest, CreateSbomExportResult> asyncHandler) {
        final CreateSbomExportRequest finalRequest = (CreateSbomExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSbomExportResult>(){

            @Override
            public CreateSbomExportResult call() throws Exception {
                CreateSbomExportResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeCreateSbomExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFilterResult> deleteFilterAsync(DeleteFilterRequest request) {
        return this.deleteFilterAsync(request, null);
    }

    @Override
    public Future<DeleteFilterResult> deleteFilterAsync(DeleteFilterRequest request, final AsyncHandler<DeleteFilterRequest, DeleteFilterResult> asyncHandler) {
        final DeleteFilterRequest finalRequest = (DeleteFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFilterResult>(){

            @Override
            public DeleteFilterResult call() throws Exception {
                DeleteFilterResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeDeleteFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrganizationConfigurationResult> describeOrganizationConfigurationAsync(DescribeOrganizationConfigurationRequest request) {
        return this.describeOrganizationConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeOrganizationConfigurationResult> describeOrganizationConfigurationAsync(DescribeOrganizationConfigurationRequest request, final AsyncHandler<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResult> asyncHandler) {
        final DescribeOrganizationConfigurationRequest finalRequest = (DescribeOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOrganizationConfigurationResult>(){

            @Override
            public DescribeOrganizationConfigurationResult call() throws Exception {
                DescribeOrganizationConfigurationResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeDescribeOrganizationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableResult> disableAsync(DisableRequest request) {
        return this.disableAsync(request, null);
    }

    @Override
    public Future<DisableResult> disableAsync(DisableRequest request, final AsyncHandler<DisableRequest, DisableResult> asyncHandler) {
        final DisableRequest finalRequest = (DisableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableResult>(){

            @Override
            public DisableResult call() throws Exception {
                DisableResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeDisable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableDelegatedAdminAccountResult> disableDelegatedAdminAccountAsync(DisableDelegatedAdminAccountRequest request) {
        return this.disableDelegatedAdminAccountAsync(request, null);
    }

    @Override
    public Future<DisableDelegatedAdminAccountResult> disableDelegatedAdminAccountAsync(DisableDelegatedAdminAccountRequest request, final AsyncHandler<DisableDelegatedAdminAccountRequest, DisableDelegatedAdminAccountResult> asyncHandler) {
        final DisableDelegatedAdminAccountRequest finalRequest = (DisableDelegatedAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableDelegatedAdminAccountResult>(){

            @Override
            public DisableDelegatedAdminAccountResult call() throws Exception {
                DisableDelegatedAdminAccountResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeDisableDelegatedAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateMemberResult> disassociateMemberAsync(DisassociateMemberRequest request) {
        return this.disassociateMemberAsync(request, null);
    }

    @Override
    public Future<DisassociateMemberResult> disassociateMemberAsync(DisassociateMemberRequest request, final AsyncHandler<DisassociateMemberRequest, DisassociateMemberResult> asyncHandler) {
        final DisassociateMemberRequest finalRequest = (DisassociateMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateMemberResult>(){

            @Override
            public DisassociateMemberResult call() throws Exception {
                DisassociateMemberResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeDisassociateMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableResult> enableAsync(EnableRequest request) {
        return this.enableAsync(request, null);
    }

    @Override
    public Future<EnableResult> enableAsync(EnableRequest request, final AsyncHandler<EnableRequest, EnableResult> asyncHandler) {
        final EnableRequest finalRequest = (EnableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableResult>(){

            @Override
            public EnableResult call() throws Exception {
                EnableResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeEnable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableDelegatedAdminAccountResult> enableDelegatedAdminAccountAsync(EnableDelegatedAdminAccountRequest request) {
        return this.enableDelegatedAdminAccountAsync(request, null);
    }

    @Override
    public Future<EnableDelegatedAdminAccountResult> enableDelegatedAdminAccountAsync(EnableDelegatedAdminAccountRequest request, final AsyncHandler<EnableDelegatedAdminAccountRequest, EnableDelegatedAdminAccountResult> asyncHandler) {
        final EnableDelegatedAdminAccountRequest finalRequest = (EnableDelegatedAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableDelegatedAdminAccountResult>(){

            @Override
            public EnableDelegatedAdminAccountResult call() throws Exception {
                EnableDelegatedAdminAccountResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeEnableDelegatedAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetConfigurationResult> getConfigurationAsync(GetConfigurationRequest request) {
        return this.getConfigurationAsync(request, null);
    }

    @Override
    public Future<GetConfigurationResult> getConfigurationAsync(GetConfigurationRequest request, final AsyncHandler<GetConfigurationRequest, GetConfigurationResult> asyncHandler) {
        final GetConfigurationRequest finalRequest = (GetConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetConfigurationResult>(){

            @Override
            public GetConfigurationResult call() throws Exception {
                GetConfigurationResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeGetConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDelegatedAdminAccountResult> getDelegatedAdminAccountAsync(GetDelegatedAdminAccountRequest request) {
        return this.getDelegatedAdminAccountAsync(request, null);
    }

    @Override
    public Future<GetDelegatedAdminAccountResult> getDelegatedAdminAccountAsync(GetDelegatedAdminAccountRequest request, final AsyncHandler<GetDelegatedAdminAccountRequest, GetDelegatedAdminAccountResult> asyncHandler) {
        final GetDelegatedAdminAccountRequest finalRequest = (GetDelegatedAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDelegatedAdminAccountResult>(){

            @Override
            public GetDelegatedAdminAccountResult call() throws Exception {
                GetDelegatedAdminAccountResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeGetDelegatedAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEc2DeepInspectionConfigurationResult> getEc2DeepInspectionConfigurationAsync(GetEc2DeepInspectionConfigurationRequest request) {
        return this.getEc2DeepInspectionConfigurationAsync(request, null);
    }

    @Override
    public Future<GetEc2DeepInspectionConfigurationResult> getEc2DeepInspectionConfigurationAsync(GetEc2DeepInspectionConfigurationRequest request, final AsyncHandler<GetEc2DeepInspectionConfigurationRequest, GetEc2DeepInspectionConfigurationResult> asyncHandler) {
        final GetEc2DeepInspectionConfigurationRequest finalRequest = (GetEc2DeepInspectionConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEc2DeepInspectionConfigurationResult>(){

            @Override
            public GetEc2DeepInspectionConfigurationResult call() throws Exception {
                GetEc2DeepInspectionConfigurationResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeGetEc2DeepInspectionConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEncryptionKeyResult> getEncryptionKeyAsync(GetEncryptionKeyRequest request) {
        return this.getEncryptionKeyAsync(request, null);
    }

    @Override
    public Future<GetEncryptionKeyResult> getEncryptionKeyAsync(GetEncryptionKeyRequest request, final AsyncHandler<GetEncryptionKeyRequest, GetEncryptionKeyResult> asyncHandler) {
        final GetEncryptionKeyRequest finalRequest = (GetEncryptionKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEncryptionKeyResult>(){

            @Override
            public GetEncryptionKeyResult call() throws Exception {
                GetEncryptionKeyResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeGetEncryptionKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFindingsReportStatusResult> getFindingsReportStatusAsync(GetFindingsReportStatusRequest request) {
        return this.getFindingsReportStatusAsync(request, null);
    }

    @Override
    public Future<GetFindingsReportStatusResult> getFindingsReportStatusAsync(GetFindingsReportStatusRequest request, final AsyncHandler<GetFindingsReportStatusRequest, GetFindingsReportStatusResult> asyncHandler) {
        final GetFindingsReportStatusRequest finalRequest = (GetFindingsReportStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFindingsReportStatusResult>(){

            @Override
            public GetFindingsReportStatusResult call() throws Exception {
                GetFindingsReportStatusResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeGetFindingsReportStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMemberResult> getMemberAsync(GetMemberRequest request) {
        return this.getMemberAsync(request, null);
    }

    @Override
    public Future<GetMemberResult> getMemberAsync(GetMemberRequest request, final AsyncHandler<GetMemberRequest, GetMemberResult> asyncHandler) {
        final GetMemberRequest finalRequest = (GetMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMemberResult>(){

            @Override
            public GetMemberResult call() throws Exception {
                GetMemberResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeGetMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSbomExportResult> getSbomExportAsync(GetSbomExportRequest request) {
        return this.getSbomExportAsync(request, null);
    }

    @Override
    public Future<GetSbomExportResult> getSbomExportAsync(GetSbomExportRequest request, final AsyncHandler<GetSbomExportRequest, GetSbomExportResult> asyncHandler) {
        final GetSbomExportRequest finalRequest = (GetSbomExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSbomExportResult>(){

            @Override
            public GetSbomExportResult call() throws Exception {
                GetSbomExportResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeGetSbomExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccountPermissionsResult> listAccountPermissionsAsync(ListAccountPermissionsRequest request) {
        return this.listAccountPermissionsAsync(request, null);
    }

    @Override
    public Future<ListAccountPermissionsResult> listAccountPermissionsAsync(ListAccountPermissionsRequest request, final AsyncHandler<ListAccountPermissionsRequest, ListAccountPermissionsResult> asyncHandler) {
        final ListAccountPermissionsRequest finalRequest = (ListAccountPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccountPermissionsResult>(){

            @Override
            public ListAccountPermissionsResult call() throws Exception {
                ListAccountPermissionsResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListAccountPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCoverageResult> listCoverageAsync(ListCoverageRequest request) {
        return this.listCoverageAsync(request, null);
    }

    @Override
    public Future<ListCoverageResult> listCoverageAsync(ListCoverageRequest request, final AsyncHandler<ListCoverageRequest, ListCoverageResult> asyncHandler) {
        final ListCoverageRequest finalRequest = (ListCoverageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCoverageResult>(){

            @Override
            public ListCoverageResult call() throws Exception {
                ListCoverageResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListCoverage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCoverageStatisticsResult> listCoverageStatisticsAsync(ListCoverageStatisticsRequest request) {
        return this.listCoverageStatisticsAsync(request, null);
    }

    @Override
    public Future<ListCoverageStatisticsResult> listCoverageStatisticsAsync(ListCoverageStatisticsRequest request, final AsyncHandler<ListCoverageStatisticsRequest, ListCoverageStatisticsResult> asyncHandler) {
        final ListCoverageStatisticsRequest finalRequest = (ListCoverageStatisticsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCoverageStatisticsResult>(){

            @Override
            public ListCoverageStatisticsResult call() throws Exception {
                ListCoverageStatisticsResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListCoverageStatistics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDelegatedAdminAccountsResult> listDelegatedAdminAccountsAsync(ListDelegatedAdminAccountsRequest request) {
        return this.listDelegatedAdminAccountsAsync(request, null);
    }

    @Override
    public Future<ListDelegatedAdminAccountsResult> listDelegatedAdminAccountsAsync(ListDelegatedAdminAccountsRequest request, final AsyncHandler<ListDelegatedAdminAccountsRequest, ListDelegatedAdminAccountsResult> asyncHandler) {
        final ListDelegatedAdminAccountsRequest finalRequest = (ListDelegatedAdminAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDelegatedAdminAccountsResult>(){

            @Override
            public ListDelegatedAdminAccountsResult call() throws Exception {
                ListDelegatedAdminAccountsResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListDelegatedAdminAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFiltersResult> listFiltersAsync(ListFiltersRequest request) {
        return this.listFiltersAsync(request, null);
    }

    @Override
    public Future<ListFiltersResult> listFiltersAsync(ListFiltersRequest request, final AsyncHandler<ListFiltersRequest, ListFiltersResult> asyncHandler) {
        final ListFiltersRequest finalRequest = (ListFiltersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFiltersResult>(){

            @Override
            public ListFiltersResult call() throws Exception {
                ListFiltersResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListFilters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingAggregationsResult> listFindingAggregationsAsync(ListFindingAggregationsRequest request) {
        return this.listFindingAggregationsAsync(request, null);
    }

    @Override
    public Future<ListFindingAggregationsResult> listFindingAggregationsAsync(ListFindingAggregationsRequest request, final AsyncHandler<ListFindingAggregationsRequest, ListFindingAggregationsResult> asyncHandler) {
        final ListFindingAggregationsRequest finalRequest = (ListFindingAggregationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFindingAggregationsResult>(){

            @Override
            public ListFindingAggregationsResult call() throws Exception {
                ListFindingAggregationsResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListFindingAggregations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(ListFindingsRequest request) {
        return this.listFindingsAsync(request, null);
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(ListFindingsRequest request, final AsyncHandler<ListFindingsRequest, ListFindingsResult> asyncHandler) {
        final ListFindingsRequest finalRequest = (ListFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFindingsResult>(){

            @Override
            public ListFindingsResult call() throws Exception {
                ListFindingsResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request) {
        return this.listMembersAsync(request, null);
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request, final AsyncHandler<ListMembersRequest, ListMembersResult> asyncHandler) {
        final ListMembersRequest finalRequest = (ListMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMembersResult>(){

            @Override
            public ListMembersResult call() throws Exception {
                ListMembersResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsageTotalsResult> listUsageTotalsAsync(ListUsageTotalsRequest request) {
        return this.listUsageTotalsAsync(request, null);
    }

    @Override
    public Future<ListUsageTotalsResult> listUsageTotalsAsync(ListUsageTotalsRequest request, final AsyncHandler<ListUsageTotalsRequest, ListUsageTotalsResult> asyncHandler) {
        final ListUsageTotalsRequest finalRequest = (ListUsageTotalsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsageTotalsResult>(){

            @Override
            public ListUsageTotalsResult call() throws Exception {
                ListUsageTotalsResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeListUsageTotals(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetEncryptionKeyResult> resetEncryptionKeyAsync(ResetEncryptionKeyRequest request) {
        return this.resetEncryptionKeyAsync(request, null);
    }

    @Override
    public Future<ResetEncryptionKeyResult> resetEncryptionKeyAsync(ResetEncryptionKeyRequest request, final AsyncHandler<ResetEncryptionKeyRequest, ResetEncryptionKeyResult> asyncHandler) {
        final ResetEncryptionKeyRequest finalRequest = (ResetEncryptionKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResetEncryptionKeyResult>(){

            @Override
            public ResetEncryptionKeyResult call() throws Exception {
                ResetEncryptionKeyResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeResetEncryptionKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchVulnerabilitiesResult> searchVulnerabilitiesAsync(SearchVulnerabilitiesRequest request) {
        return this.searchVulnerabilitiesAsync(request, null);
    }

    @Override
    public Future<SearchVulnerabilitiesResult> searchVulnerabilitiesAsync(SearchVulnerabilitiesRequest request, final AsyncHandler<SearchVulnerabilitiesRequest, SearchVulnerabilitiesResult> asyncHandler) {
        final SearchVulnerabilitiesRequest finalRequest = (SearchVulnerabilitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchVulnerabilitiesResult>(){

            @Override
            public SearchVulnerabilitiesResult call() throws Exception {
                SearchVulnerabilitiesResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeSearchVulnerabilities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConfigurationResult> updateConfigurationAsync(UpdateConfigurationRequest request) {
        return this.updateConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateConfigurationResult> updateConfigurationAsync(UpdateConfigurationRequest request, final AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResult> asyncHandler) {
        final UpdateConfigurationRequest finalRequest = (UpdateConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConfigurationResult>(){

            @Override
            public UpdateConfigurationResult call() throws Exception {
                UpdateConfigurationResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeUpdateConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEc2DeepInspectionConfigurationResult> updateEc2DeepInspectionConfigurationAsync(UpdateEc2DeepInspectionConfigurationRequest request) {
        return this.updateEc2DeepInspectionConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateEc2DeepInspectionConfigurationResult> updateEc2DeepInspectionConfigurationAsync(UpdateEc2DeepInspectionConfigurationRequest request, final AsyncHandler<UpdateEc2DeepInspectionConfigurationRequest, UpdateEc2DeepInspectionConfigurationResult> asyncHandler) {
        final UpdateEc2DeepInspectionConfigurationRequest finalRequest = (UpdateEc2DeepInspectionConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEc2DeepInspectionConfigurationResult>(){

            @Override
            public UpdateEc2DeepInspectionConfigurationResult call() throws Exception {
                UpdateEc2DeepInspectionConfigurationResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeUpdateEc2DeepInspectionConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEncryptionKeyResult> updateEncryptionKeyAsync(UpdateEncryptionKeyRequest request) {
        return this.updateEncryptionKeyAsync(request, null);
    }

    @Override
    public Future<UpdateEncryptionKeyResult> updateEncryptionKeyAsync(UpdateEncryptionKeyRequest request, final AsyncHandler<UpdateEncryptionKeyRequest, UpdateEncryptionKeyResult> asyncHandler) {
        final UpdateEncryptionKeyRequest finalRequest = (UpdateEncryptionKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEncryptionKeyResult>(){

            @Override
            public UpdateEncryptionKeyResult call() throws Exception {
                UpdateEncryptionKeyResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeUpdateEncryptionKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFilterResult> updateFilterAsync(UpdateFilterRequest request) {
        return this.updateFilterAsync(request, null);
    }

    @Override
    public Future<UpdateFilterResult> updateFilterAsync(UpdateFilterRequest request, final AsyncHandler<UpdateFilterRequest, UpdateFilterResult> asyncHandler) {
        final UpdateFilterRequest finalRequest = (UpdateFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFilterResult>(){

            @Override
            public UpdateFilterResult call() throws Exception {
                UpdateFilterResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeUpdateFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateOrgEc2DeepInspectionConfigurationResult> updateOrgEc2DeepInspectionConfigurationAsync(UpdateOrgEc2DeepInspectionConfigurationRequest request) {
        return this.updateOrgEc2DeepInspectionConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateOrgEc2DeepInspectionConfigurationResult> updateOrgEc2DeepInspectionConfigurationAsync(UpdateOrgEc2DeepInspectionConfigurationRequest request, final AsyncHandler<UpdateOrgEc2DeepInspectionConfigurationRequest, UpdateOrgEc2DeepInspectionConfigurationResult> asyncHandler) {
        final UpdateOrgEc2DeepInspectionConfigurationRequest finalRequest = (UpdateOrgEc2DeepInspectionConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateOrgEc2DeepInspectionConfigurationResult>(){

            @Override
            public UpdateOrgEc2DeepInspectionConfigurationResult call() throws Exception {
                UpdateOrgEc2DeepInspectionConfigurationResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeUpdateOrgEc2DeepInspectionConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateOrganizationConfigurationResult> updateOrganizationConfigurationAsync(UpdateOrganizationConfigurationRequest request) {
        return this.updateOrganizationConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateOrganizationConfigurationResult> updateOrganizationConfigurationAsync(UpdateOrganizationConfigurationRequest request, final AsyncHandler<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResult> asyncHandler) {
        final UpdateOrganizationConfigurationRequest finalRequest = (UpdateOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateOrganizationConfigurationResult>(){

            @Override
            public UpdateOrganizationConfigurationResult call() throws Exception {
                UpdateOrganizationConfigurationResult result = null;
                try {
                    result = AWSInspector2AsyncClient.this.executeUpdateOrganizationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

