/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.guardduty.model.S3ObjectDetail;

@SdkInternalApi
public class S3ObjectDetailMarshaller {
    private static final MarshallingInfo<String> OBJECTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectArn").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final MarshallingInfo<String> ETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eTag").build();
    private static final MarshallingInfo<String> HASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hash").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionId").build();
    private static final S3ObjectDetailMarshaller instance = new S3ObjectDetailMarshaller();

    public static S3ObjectDetailMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ObjectDetail s3ObjectDetail, ProtocolMarshaller protocolMarshaller) {
        if (s3ObjectDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ObjectDetail.getObjectArn(), OBJECTARN_BINDING);
            protocolMarshaller.marshall((Object)s3ObjectDetail.getKey(), KEY_BINDING);
            protocolMarshaller.marshall((Object)s3ObjectDetail.getETag(), ETAG_BINDING);
            protocolMarshaller.marshall((Object)s3ObjectDetail.getHash(), HASH_BINDING);
            protocolMarshaller.marshall((Object)s3ObjectDetail.getVersionId(), VERSIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

