/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.transform.DataQualityAnalyzerResultMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataQualityAnalyzerResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String evaluationMessage;
    private Map<String, Double> evaluatedMetrics;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DataQualityAnalyzerResult withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DataQualityAnalyzerResult withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEvaluationMessage(String evaluationMessage) {
        this.evaluationMessage = evaluationMessage;
    }

    public String getEvaluationMessage() {
        return this.evaluationMessage;
    }

    public DataQualityAnalyzerResult withEvaluationMessage(String evaluationMessage) {
        this.setEvaluationMessage(evaluationMessage);
        return this;
    }

    public Map<String, Double> getEvaluatedMetrics() {
        return this.evaluatedMetrics;
    }

    public void setEvaluatedMetrics(Map<String, Double> evaluatedMetrics) {
        this.evaluatedMetrics = evaluatedMetrics;
    }

    public DataQualityAnalyzerResult withEvaluatedMetrics(Map<String, Double> evaluatedMetrics) {
        this.setEvaluatedMetrics(evaluatedMetrics);
        return this;
    }

    public DataQualityAnalyzerResult addEvaluatedMetricsEntry(String key, Double value) {
        if (null == this.evaluatedMetrics) {
            this.evaluatedMetrics = new HashMap<String, Double>();
        }
        if (this.evaluatedMetrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.evaluatedMetrics.put(key, value);
        return this;
    }

    public DataQualityAnalyzerResult clearEvaluatedMetricsEntries() {
        this.evaluatedMetrics = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEvaluationMessage() != null) {
            sb.append("EvaluationMessage: ").append(this.getEvaluationMessage()).append(",");
        }
        if (this.getEvaluatedMetrics() != null) {
            sb.append("EvaluatedMetrics: ").append(this.getEvaluatedMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityAnalyzerResult)) {
            return false;
        }
        DataQualityAnalyzerResult other = (DataQualityAnalyzerResult)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEvaluationMessage() == null ^ this.getEvaluationMessage() == null) {
            return false;
        }
        if (other.getEvaluationMessage() != null && !other.getEvaluationMessage().equals(this.getEvaluationMessage())) {
            return false;
        }
        if (other.getEvaluatedMetrics() == null ^ this.getEvaluatedMetrics() == null) {
            return false;
        }
        return other.getEvaluatedMetrics() == null || other.getEvaluatedMetrics().equals(this.getEvaluatedMetrics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationMessage() == null ? 0 : this.getEvaluationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluatedMetrics() == null ? 0 : this.getEvaluatedMetrics().hashCode());
        return hashCode;
    }

    public DataQualityAnalyzerResult clone() {
        try {
            return (DataQualityAnalyzerResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataQualityAnalyzerResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

