/*
 * Copyright 2011-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.protocol.DefaultValueSupplier;

public class DefaultAccountIdSupplier implements DefaultValueSupplier<String> {

    private static final DefaultAccountIdSupplier INSTANCE = new DefaultAccountIdSupplier();

    /**
     * Value that indicates the current account.
     */
    private static final String CURRENT_ACCOUNT_ID = "-";

    public static DefaultAccountIdSupplier getInstance() {
        return INSTANCE;
    }

    private DefaultAccountIdSupplier() {
    }

    @Override
    public String get() {
        return CURRENT_ACCOUNT_ID;
    }
}
