/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.frauddetector.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutKMSEncryptionKeyRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The KMS encryption key ARN.
     * </p>
     * <p>
     * The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     * </p>
     */
    private String kmsEncryptionKeyArn;

    /**
     * <p>
     * The KMS encryption key ARN.
     * </p>
     * <p>
     * The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     * </p>
     * 
     * @param kmsEncryptionKeyArn
     *        The KMS encryption key ARN.</p>
     *        <p>
     *        The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     */

    public void setKmsEncryptionKeyArn(String kmsEncryptionKeyArn) {
        this.kmsEncryptionKeyArn = kmsEncryptionKeyArn;
    }

    /**
     * <p>
     * The KMS encryption key ARN.
     * </p>
     * <p>
     * The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     * </p>
     * 
     * @return The KMS encryption key ARN.</p>
     *         <p>
     *         The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     */

    public String getKmsEncryptionKeyArn() {
        return this.kmsEncryptionKeyArn;
    }

    /**
     * <p>
     * The KMS encryption key ARN.
     * </p>
     * <p>
     * The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     * </p>
     * 
     * @param kmsEncryptionKeyArn
     *        The KMS encryption key ARN.</p>
     *        <p>
     *        The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutKMSEncryptionKeyRequest withKmsEncryptionKeyArn(String kmsEncryptionKeyArn) {
        setKmsEncryptionKeyArn(kmsEncryptionKeyArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getKmsEncryptionKeyArn() != null)
            sb.append("KmsEncryptionKeyArn: ").append(getKmsEncryptionKeyArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutKMSEncryptionKeyRequest == false)
            return false;
        PutKMSEncryptionKeyRequest other = (PutKMSEncryptionKeyRequest) obj;
        if (other.getKmsEncryptionKeyArn() == null ^ this.getKmsEncryptionKeyArn() == null)
            return false;
        if (other.getKmsEncryptionKeyArn() != null && other.getKmsEncryptionKeyArn().equals(this.getKmsEncryptionKeyArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getKmsEncryptionKeyArn() == null) ? 0 : getKmsEncryptionKeyArn().hashCode());
        return hashCode;
    }

    @Override
    public PutKMSEncryptionKeyRequest clone() {
        return (PutKMSEncryptionKeyRequest) super.clone();
    }

}
