/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.CacheNodeTypeSpecificParameter;
import com.amazonaws.services.elasticache.model.EngineDefaults;
import com.amazonaws.services.elasticache.model.Parameter;
import com.amazonaws.services.elasticache.model.transform.CacheNodeTypeSpecificParameterStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ParameterStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class EngineDefaultsStaxUnmarshaller
implements Unmarshaller<EngineDefaults, StaxUnmarshallerContext> {
    private static EngineDefaultsStaxUnmarshaller instance;

    public EngineDefaults unmarshall(StaxUnmarshallerContext context) throws Exception {
        EngineDefaults engineDefaults = new EngineDefaults();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return engineDefaults;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheParameterGroupFamily", targetDepth)) {
                    engineDefaults.setCacheParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Marker", targetDepth)) {
                    engineDefaults.setMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    engineDefaults.withParameters(new ArrayList<Parameter>());
                    continue;
                }
                if (context.testExpression("Parameters/Parameter", targetDepth)) {
                    engineDefaults.withParameters(ParameterStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeTypeSpecificParameters", targetDepth)) {
                    engineDefaults.withCacheNodeTypeSpecificParameters(new ArrayList<CacheNodeTypeSpecificParameter>());
                    continue;
                }
                if (!context.testExpression("CacheNodeTypeSpecificParameters/CacheNodeTypeSpecificParameter", targetDepth)) continue;
                engineDefaults.withCacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameterStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return engineDefaults;
    }

    public static EngineDefaultsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EngineDefaultsStaxUnmarshaller();
        }
        return instance;
    }
}

