/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directconnect.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateLagRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Integer numberOfConnections;
    private String location;
    private String connectionsBandwidth;
    private String lagName;
    private String connectionId;
    private SdkInternalList<Tag> tags;
    private SdkInternalList<Tag> childConnectionTags;
    private String providerName;
    private Boolean requestMACSec;

    public void setNumberOfConnections(Integer numberOfConnections) {
        this.numberOfConnections = numberOfConnections;
    }

    public Integer getNumberOfConnections() {
        return this.numberOfConnections;
    }

    public CreateLagRequest withNumberOfConnections(Integer numberOfConnections) {
        this.setNumberOfConnections(numberOfConnections);
        return this;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public CreateLagRequest withLocation(String location) {
        this.setLocation(location);
        return this;
    }

    public void setConnectionsBandwidth(String connectionsBandwidth) {
        this.connectionsBandwidth = connectionsBandwidth;
    }

    public String getConnectionsBandwidth() {
        return this.connectionsBandwidth;
    }

    public CreateLagRequest withConnectionsBandwidth(String connectionsBandwidth) {
        this.setConnectionsBandwidth(connectionsBandwidth);
        return this;
    }

    public void setLagName(String lagName) {
        this.lagName = lagName;
    }

    public String getLagName() {
        return this.lagName;
    }

    public CreateLagRequest withLagName(String lagName) {
        this.setLagName(lagName);
        return this;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public CreateLagRequest withConnectionId(String connectionId) {
        this.setConnectionId(connectionId);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateLagRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateLagRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<Tag> getChildConnectionTags() {
        if (this.childConnectionTags == null) {
            this.childConnectionTags = new SdkInternalList();
        }
        return this.childConnectionTags;
    }

    public void setChildConnectionTags(Collection<Tag> childConnectionTags) {
        if (childConnectionTags == null) {
            this.childConnectionTags = null;
            return;
        }
        this.childConnectionTags = new SdkInternalList(childConnectionTags);
    }

    public CreateLagRequest withChildConnectionTags(Tag ... childConnectionTags) {
        if (this.childConnectionTags == null) {
            this.setChildConnectionTags((Collection<Tag>)new SdkInternalList(childConnectionTags.length));
        }
        for (Tag ele : childConnectionTags) {
            this.childConnectionTags.add((Object)ele);
        }
        return this;
    }

    public CreateLagRequest withChildConnectionTags(Collection<Tag> childConnectionTags) {
        this.setChildConnectionTags(childConnectionTags);
        return this;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public CreateLagRequest withProviderName(String providerName) {
        this.setProviderName(providerName);
        return this;
    }

    public void setRequestMACSec(Boolean requestMACSec) {
        this.requestMACSec = requestMACSec;
    }

    public Boolean getRequestMACSec() {
        return this.requestMACSec;
    }

    public CreateLagRequest withRequestMACSec(Boolean requestMACSec) {
        this.setRequestMACSec(requestMACSec);
        return this;
    }

    public Boolean isRequestMACSec() {
        return this.requestMACSec;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNumberOfConnections() != null) {
            sb.append("NumberOfConnections: ").append(this.getNumberOfConnections()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getConnectionsBandwidth() != null) {
            sb.append("ConnectionsBandwidth: ").append(this.getConnectionsBandwidth()).append(",");
        }
        if (this.getLagName() != null) {
            sb.append("LagName: ").append(this.getLagName()).append(",");
        }
        if (this.getConnectionId() != null) {
            sb.append("ConnectionId: ").append(this.getConnectionId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getChildConnectionTags() != null) {
            sb.append("ChildConnectionTags: ").append(this.getChildConnectionTags()).append(",");
        }
        if (this.getProviderName() != null) {
            sb.append("ProviderName: ").append(this.getProviderName()).append(",");
        }
        if (this.getRequestMACSec() != null) {
            sb.append("RequestMACSec: ").append(this.getRequestMACSec());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLagRequest)) {
            return false;
        }
        CreateLagRequest other = (CreateLagRequest)obj;
        if (other.getNumberOfConnections() == null ^ this.getNumberOfConnections() == null) {
            return false;
        }
        if (other.getNumberOfConnections() != null && !other.getNumberOfConnections().equals(this.getNumberOfConnections())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getConnectionsBandwidth() == null ^ this.getConnectionsBandwidth() == null) {
            return false;
        }
        if (other.getConnectionsBandwidth() != null && !other.getConnectionsBandwidth().equals(this.getConnectionsBandwidth())) {
            return false;
        }
        if (other.getLagName() == null ^ this.getLagName() == null) {
            return false;
        }
        if (other.getLagName() != null && !other.getLagName().equals(this.getLagName())) {
            return false;
        }
        if (other.getConnectionId() == null ^ this.getConnectionId() == null) {
            return false;
        }
        if (other.getConnectionId() != null && !other.getConnectionId().equals(this.getConnectionId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getChildConnectionTags() == null ^ this.getChildConnectionTags() == null) {
            return false;
        }
        if (other.getChildConnectionTags() != null && !other.getChildConnectionTags().equals(this.getChildConnectionTags())) {
            return false;
        }
        if (other.getProviderName() == null ^ this.getProviderName() == null) {
            return false;
        }
        if (other.getProviderName() != null && !other.getProviderName().equals(this.getProviderName())) {
            return false;
        }
        if (other.getRequestMACSec() == null ^ this.getRequestMACSec() == null) {
            return false;
        }
        return other.getRequestMACSec() == null || other.getRequestMACSec().equals(this.getRequestMACSec());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNumberOfConnections() == null ? 0 : this.getNumberOfConnections().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionsBandwidth() == null ? 0 : this.getConnectionsBandwidth().hashCode());
        hashCode = 31 * hashCode + (this.getLagName() == null ? 0 : this.getLagName().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionId() == null ? 0 : this.getConnectionId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getChildConnectionTags() == null ? 0 : this.getChildConnectionTags().hashCode());
        hashCode = 31 * hashCode + (this.getProviderName() == null ? 0 : this.getProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getRequestMACSec() == null ? 0 : this.getRequestMACSec().hashCode());
        return hashCode;
    }

    public CreateLagRequest clone() {
        return (CreateLagRequest)super.clone();
    }
}

