/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import jakarta.jms.ConnectionMetaData;
import jakarta.jms.JMSException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class SQSConnectionMetaData
implements ConnectionMetaData {
    private final String jmsVersion;
    private final int jmsMajorVersion;
    private final int jmsMinorVersion;
    private final String jmsProviderName;
    private final String providerVersion;
    private final int providerMajorVersion;
    private final int providerMinorVersion;
    private final List<String> jmsxProperty = List.of("JMSXDeliveryCount", "JMSXGroupID", "JMSXGroupSeq");

    SQSConnectionMetaData() {
        this.jmsVersion = "1.1";
        this.jmsMajorVersion = 1;
        this.jmsMinorVersion = 1;
        this.jmsProviderName = "Amazon";
        this.providerVersion = "1.0";
        this.providerMajorVersion = 1;
        this.providerMinorVersion = 0;
    }

    public String getJMSVersion() throws JMSException {
        return this.jmsVersion;
    }

    public int getJMSMajorVersion() throws JMSException {
        return this.jmsMajorVersion;
    }

    public int getJMSMinorVersion() throws JMSException {
        return this.jmsMinorVersion;
    }

    public String getJMSProviderName() throws JMSException {
        return this.jmsProviderName;
    }

    public String getProviderVersion() throws JMSException {
        return this.providerVersion;
    }

    public int getProviderMajorVersion() throws JMSException {
        return this.providerMajorVersion;
    }

    public int getProviderMinorVersion() throws JMSException {
        return this.providerMinorVersion;
    }

    public Enumeration<String> getJMSXPropertyNames() throws JMSException {
        return Collections.enumeration(this.jmsxProperty);
    }
}

