/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.ProviderConfiguration;
import com.amazon.sqs.javamessaging.SQSConnection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import java.util.function.Supplier;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public class SQSConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory {
    private final ProviderConfiguration providerConfiguration;
    private final Supplier<SqsClient> amazonSQSClientSupplier;

    public SQSConnectionFactory() {
        this(new ProviderConfiguration());
    }

    public SQSConnectionFactory(ProviderConfiguration providerConfiguration) {
        this(providerConfiguration, SqsClient.create());
    }

    public SQSConnectionFactory(ProviderConfiguration providerConfiguration, SqsClient client) {
        if (providerConfiguration == null) {
            throw new IllegalArgumentException("Provider configuration cannot be null");
        }
        if (client == null) {
            throw new IllegalArgumentException("AmazonSQS client cannot be null");
        }
        this.providerConfiguration = providerConfiguration;
        this.amazonSQSClientSupplier = () -> client;
    }

    public SQSConnectionFactory(ProviderConfiguration providerConfiguration, SqsClientBuilder clientBuilder) {
        if (providerConfiguration == null) {
            throw new IllegalArgumentException("Provider configuration cannot be null");
        }
        if (clientBuilder == null) {
            throw new IllegalArgumentException("AmazonSQS client builder cannot be null");
        }
        this.providerConfiguration = providerConfiguration;
        this.amazonSQSClientSupplier = () -> ((SqsClientBuilder)clientBuilder).build();
    }

    public SQSConnection createConnection() throws JMSException {
        try {
            SqsClient amazonSQS = this.amazonSQSClientSupplier.get();
            return this.createConnection(amazonSQS, null);
        }
        catch (RuntimeException e) {
            throw (JMSException)new JMSException("Error creating SQS client: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    public SQSConnection createConnection(String awsAccessKeyId, String awsSecretKey) throws JMSException {
        AwsBasicCredentials basicAWSCredentials = AwsBasicCredentials.create((String)awsAccessKeyId, (String)awsSecretKey);
        return this.createConnection((AwsCredentials)basicAWSCredentials);
    }

    public JMSContext createContext() {
        throw new JMSRuntimeException("Unsupported Method");
    }

    public JMSContext createContext(String userName, String password) {
        throw new JMSRuntimeException("Unsupported Method");
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        throw new JMSRuntimeException("Unsupported Method");
    }

    public JMSContext createContext(int sessionMode) {
        throw new JMSRuntimeException("Unsupported Method");
    }

    public SQSConnection createConnection(AwsCredentials awsCredentials) throws JMSException {
        StaticCredentialsProvider awsCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        return this.createConnection((AwsCredentialsProvider)awsCredentialsProvider);
    }

    public SQSConnection createConnection(AwsCredentialsProvider awsCredentialsProvider) throws JMSException {
        try {
            SqsClient amazonSQS = this.amazonSQSClientSupplier.get();
            return this.createConnection(amazonSQS, awsCredentialsProvider);
        }
        catch (Exception e) {
            throw (JMSException)new JMSException("Error creating SQS client: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    private SQSConnection createConnection(SqsClient amazonSQS, AwsCredentialsProvider awsCredentialsProvider) throws JMSException {
        AmazonSQSMessagingClientWrapper amazonSQSClientJMSWrapper = new AmazonSQSMessagingClientWrapper(amazonSQS, awsCredentialsProvider);
        return new SQSConnection(amazonSQSClientJMSWrapper, this.providerConfiguration.getNumberOfMessagesToPrefetch());
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password);
    }
}

