/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.gadgetController;

import com.amazon.ask.model.services.gadgetController.LightAnimation;
import com.amazon.ask.model.services.gadgetController.TriggerEventType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SetLightParameters {
    @JsonProperty(value="triggerEvent")
    private String triggerEvent = null;
    @JsonProperty(value="triggerEventTimeMs")
    private Integer triggerEventTimeMs = null;
    @JsonProperty(value="animations")
    private List<LightAnimation> animations = new ArrayList<LightAnimation>();

    private SetLightParameters() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SetLightParameters(Builder builder) {
        if (builder.triggerEvent != null) {
            this.triggerEvent = builder.triggerEvent;
        }
        if (builder.triggerEventTimeMs != null) {
            this.triggerEventTimeMs = builder.triggerEventTimeMs;
        }
        if (builder.animations != null) {
            this.animations = builder.animations;
        }
    }

    public TriggerEventType getTriggerEvent() {
        return TriggerEventType.fromValue(this.triggerEvent);
    }

    @JsonProperty(value="triggerEvent")
    public String getTriggerEventAsString() {
        return this.triggerEvent;
    }

    @JsonProperty(value="triggerEventTimeMs")
    public Integer getTriggerEventTimeMs() {
        return this.triggerEventTimeMs;
    }

    @JsonProperty(value="animations")
    public List<LightAnimation> getAnimations() {
        return this.animations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetLightParameters servicesGadgetControllerSetLightParameters = (SetLightParameters)o;
        return Objects.equals(this.triggerEvent, servicesGadgetControllerSetLightParameters.triggerEvent) && Objects.equals(this.triggerEventTimeMs, servicesGadgetControllerSetLightParameters.triggerEventTimeMs) && Objects.equals(this.animations, servicesGadgetControllerSetLightParameters.animations);
    }

    public int hashCode() {
        return Objects.hash(this.triggerEvent, this.triggerEventTimeMs, this.animations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetLightParameters {\n");
        sb.append("    triggerEvent: ").append(this.toIndentedString(this.triggerEvent)).append("\n");
        sb.append("    triggerEventTimeMs: ").append(this.toIndentedString(this.triggerEventTimeMs)).append("\n");
        sb.append("    animations: ").append(this.toIndentedString(this.animations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String triggerEvent;
        private Integer triggerEventTimeMs;
        private List<LightAnimation> animations;

        private Builder() {
        }

        @JsonProperty(value="triggerEvent")
        public Builder withTriggerEvent(String triggerEvent) {
            this.triggerEvent = triggerEvent;
            return this;
        }

        public Builder withTriggerEvent(TriggerEventType triggerEvent) {
            this.triggerEvent = triggerEvent != null ? triggerEvent.toString() : null;
            return this;
        }

        @JsonProperty(value="triggerEventTimeMs")
        public Builder withTriggerEventTimeMs(Integer triggerEventTimeMs) {
            this.triggerEventTimeMs = triggerEventTimeMs;
            return this;
        }

        @JsonProperty(value="animations")
        public Builder withAnimations(List<LightAnimation> animations) {
            this.animations = animations;
            return this;
        }

        public Builder addAnimationsItem(LightAnimation animationsItem) {
            if (this.animations == null) {
                this.animations = new ArrayList<LightAnimation>();
            }
            this.animations.add(animationsItem);
            return this;
        }

        public SetLightParameters build() {
            return new SetLightParameters(this);
        }
    }
}

