/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.ComponentEntity;
import com.amazon.ask.model.interfaces.alexa.presentation.apl.ComponentVisibleOnScreenMediaTagStateEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ComponentVisibleOnScreenMediaTag {
    @JsonProperty(value="positionInMilliseconds")
    private Integer positionInMilliseconds = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="allowAdjustSeekPositionForward")
    private Boolean allowAdjustSeekPositionForward = null;
    @JsonProperty(value="allowAdjustSeekPositionBackwards")
    private Boolean allowAdjustSeekPositionBackwards = null;
    @JsonProperty(value="allowNext")
    private Boolean allowNext = null;
    @JsonProperty(value="allowPrevious")
    private Boolean allowPrevious = null;
    @JsonProperty(value="entities")
    private List<ComponentEntity> entities = new ArrayList<ComponentEntity>();
    @JsonProperty(value="url")
    private String url = null;

    private ComponentVisibleOnScreenMediaTag() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ComponentVisibleOnScreenMediaTag(Builder builder) {
        if (builder.positionInMilliseconds != null) {
            this.positionInMilliseconds = builder.positionInMilliseconds;
        }
        if (builder.state != null) {
            this.state = builder.state;
        }
        if (builder.allowAdjustSeekPositionForward != null) {
            this.allowAdjustSeekPositionForward = builder.allowAdjustSeekPositionForward;
        }
        if (builder.allowAdjustSeekPositionBackwards != null) {
            this.allowAdjustSeekPositionBackwards = builder.allowAdjustSeekPositionBackwards;
        }
        if (builder.allowNext != null) {
            this.allowNext = builder.allowNext;
        }
        if (builder.allowPrevious != null) {
            this.allowPrevious = builder.allowPrevious;
        }
        if (builder.entities != null) {
            this.entities = builder.entities;
        }
        if (builder.url != null) {
            this.url = builder.url;
        }
    }

    @JsonProperty(value="positionInMilliseconds")
    public Integer getPositionInMilliseconds() {
        return this.positionInMilliseconds;
    }

    public ComponentVisibleOnScreenMediaTagStateEnum getState() {
        return ComponentVisibleOnScreenMediaTagStateEnum.fromValue(this.state);
    }

    @JsonProperty(value="state")
    public String getStateAsString() {
        return this.state;
    }

    @JsonProperty(value="allowAdjustSeekPositionForward")
    public Boolean getAllowAdjustSeekPositionForward() {
        return this.allowAdjustSeekPositionForward;
    }

    @JsonProperty(value="allowAdjustSeekPositionBackwards")
    public Boolean getAllowAdjustSeekPositionBackwards() {
        return this.allowAdjustSeekPositionBackwards;
    }

    @JsonProperty(value="allowNext")
    public Boolean getAllowNext() {
        return this.allowNext;
    }

    @JsonProperty(value="allowPrevious")
    public Boolean getAllowPrevious() {
        return this.allowPrevious;
    }

    @JsonProperty(value="entities")
    public List<ComponentEntity> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentVisibleOnScreenMediaTag interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag = (ComponentVisibleOnScreenMediaTag)o;
        return Objects.equals(this.positionInMilliseconds, interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag.positionInMilliseconds) && Objects.equals(this.state, interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag.state) && Objects.equals(this.allowAdjustSeekPositionForward, interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag.allowAdjustSeekPositionForward) && Objects.equals(this.allowAdjustSeekPositionBackwards, interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag.allowAdjustSeekPositionBackwards) && Objects.equals(this.allowNext, interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag.allowNext) && Objects.equals(this.allowPrevious, interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag.allowPrevious) && Objects.equals(this.entities, interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag.entities) && Objects.equals(this.url, interfacesAlexaPresentationAplComponentVisibleOnScreenMediaTag.url);
    }

    public int hashCode() {
        return Objects.hash(this.positionInMilliseconds, this.state, this.allowAdjustSeekPositionForward, this.allowAdjustSeekPositionBackwards, this.allowNext, this.allowPrevious, this.entities, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComponentVisibleOnScreenMediaTag {\n");
        sb.append("    positionInMilliseconds: ").append(this.toIndentedString(this.positionInMilliseconds)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    allowAdjustSeekPositionForward: ").append(this.toIndentedString(this.allowAdjustSeekPositionForward)).append("\n");
        sb.append("    allowAdjustSeekPositionBackwards: ").append(this.toIndentedString(this.allowAdjustSeekPositionBackwards)).append("\n");
        sb.append("    allowNext: ").append(this.toIndentedString(this.allowNext)).append("\n");
        sb.append("    allowPrevious: ").append(this.toIndentedString(this.allowPrevious)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Integer positionInMilliseconds;
        private String state;
        private Boolean allowAdjustSeekPositionForward;
        private Boolean allowAdjustSeekPositionBackwards;
        private Boolean allowNext;
        private Boolean allowPrevious;
        private List<ComponentEntity> entities;
        private String url;

        private Builder() {
        }

        @JsonProperty(value="positionInMilliseconds")
        public Builder withPositionInMilliseconds(Integer positionInMilliseconds) {
            this.positionInMilliseconds = positionInMilliseconds;
            return this;
        }

        @JsonProperty(value="state")
        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withState(ComponentVisibleOnScreenMediaTagStateEnum state) {
            this.state = state != null ? state.toString() : null;
            return this;
        }

        @JsonProperty(value="allowAdjustSeekPositionForward")
        public Builder withAllowAdjustSeekPositionForward(Boolean allowAdjustSeekPositionForward) {
            this.allowAdjustSeekPositionForward = allowAdjustSeekPositionForward;
            return this;
        }

        @JsonProperty(value="allowAdjustSeekPositionBackwards")
        public Builder withAllowAdjustSeekPositionBackwards(Boolean allowAdjustSeekPositionBackwards) {
            this.allowAdjustSeekPositionBackwards = allowAdjustSeekPositionBackwards;
            return this;
        }

        @JsonProperty(value="allowNext")
        public Builder withAllowNext(Boolean allowNext) {
            this.allowNext = allowNext;
            return this;
        }

        @JsonProperty(value="allowPrevious")
        public Builder withAllowPrevious(Boolean allowPrevious) {
            this.allowPrevious = allowPrevious;
            return this;
        }

        @JsonProperty(value="entities")
        public Builder withEntities(List<ComponentEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder addEntitiesItem(ComponentEntity entitiesItem) {
            if (this.entities == null) {
                this.entities = new ArrayList<ComponentEntity>();
            }
            this.entities.add(entitiesItem);
            return this;
        }

        @JsonProperty(value="url")
        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public ComponentVisibleOnScreenMediaTag build() {
            return new ComponentVisibleOnScreenMediaTag(this);
        }
    }
}

