/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client;

import com.aliyun.mns.client.AsyncCallback;
import com.aliyun.mns.client.AsyncResult;
import com.aliyun.mns.client.impl.queue.BatchDeleteMessageAction;
import com.aliyun.mns.client.impl.queue.BatchPeekMessageAction;
import com.aliyun.mns.client.impl.queue.BatchReceiveMessageAction;
import com.aliyun.mns.client.impl.queue.BatchSendMessageAction;
import com.aliyun.mns.client.impl.queue.ChangeVisibilityAction;
import com.aliyun.mns.client.impl.queue.ChangeVisibilityTimeoutAction;
import com.aliyun.mns.client.impl.queue.CreateQueueAction;
import com.aliyun.mns.client.impl.queue.DeleteMessageAction;
import com.aliyun.mns.client.impl.queue.DeleteQueueAction;
import com.aliyun.mns.client.impl.queue.GetQueueAttrAction;
import com.aliyun.mns.client.impl.queue.PeekMessageAction;
import com.aliyun.mns.client.impl.queue.ReceiveMessageAction;
import com.aliyun.mns.client.impl.queue.SendMessageAction;
import com.aliyun.mns.client.impl.queue.SetQueueAttrAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.QueueMeta;
import com.aliyun.mns.model.request.queue.BatchDeleteMessageRequest;
import com.aliyun.mns.model.request.queue.BatchPeekMessageRequest;
import com.aliyun.mns.model.request.queue.BatchReceiveMessageRequest;
import com.aliyun.mns.model.request.queue.BatchSendMessageRequest;
import com.aliyun.mns.model.request.queue.ChangeVisibilityTimeoutRequest;
import com.aliyun.mns.model.request.queue.CreateQueueRequest;
import com.aliyun.mns.model.request.queue.DeleteMessageRequest;
import com.aliyun.mns.model.request.queue.DeleteQueueRequest;
import com.aliyun.mns.model.request.queue.GetQueueAttrRequest;
import com.aliyun.mns.model.request.queue.PeekMessageRequest;
import com.aliyun.mns.model.request.queue.ReceiveMessageRequest;
import com.aliyun.mns.model.request.queue.SendMessageRequest;
import com.aliyun.mns.model.request.queue.SetQueueAttrRequest;
import java.net.URI;
import java.util.List;
import java.util.Map;

public final class CloudQueue {
    private ServiceClient serviceClient;
    private String queueURL;
    private ServiceCredentials credentials;
    private URI endpoint;
    private Map<String, String> customHeaders = null;

    protected CloudQueue(String queueURL, ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        this.serviceClient = client;
        this.credentials = credentials;
        this.endpoint = endpoint;
        if (queueURL == null || queueURL.equals("")) {
            throw new NullPointerException("QueueURL parameter can not be empty.");
        }
        String uri = endpoint.toString();
        if (queueURL.startsWith(uri)) {
            this.queueURL = queueURL;
        } else {
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            if (queueURL != null) {
                uri = uri + "queues/" + queueURL;
            }
            this.queueURL = uri;
        }
    }

    void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public String create() throws ServiceException, ClientException {
        return this.create(null);
    }

    public String create(QueueMeta queueMeta) throws ServiceException, ClientException {
        CreateQueueAction action = new CreateQueueAction(this.serviceClient, this.credentials, this.endpoint);
        String queueName = this.drillQueueName();
        CreateQueueRequest request = new CreateQueueRequest();
        if (queueMeta == null || queueMeta.getQueueName() == null) {
            queueMeta = new QueueMeta();
            queueMeta.setQueueName(queueName);
        } else if (queueMeta.getQueueName() == null || queueMeta.getQueueName().isEmpty()) {
            queueMeta.setQueueName(queueName);
        } else if (!queueName.equals(queueMeta.getQueueName())) {
            throw new ClientException("QueueName conflict between meta queue name and  queue url offered.", action.getUserRequestId());
        }
        request.setRequestPath("queues/" + queueMeta.getQueueName());
        request.setQueueMeta(queueMeta);
        return (String)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    private String drillQueueName() {
        String queueName = null;
        if (this.queueURL.startsWith(this.endpoint.toString())) {
            queueName = this.queueURL.substring(this.endpoint.toString().length() + 1 + "queues/".length());
        }
        while (queueName != null && queueName.trim().length() > 0 && queueName.startsWith("/")) {
            queueName = queueName.substring(1);
        }
        if (queueName == null || queueName.trim().length() == 0) {
            throw new NullPointerException("Queue Name can not be null.");
        }
        return queueName;
    }

    public void delete() throws ServiceException, ClientException {
        DeleteQueueAction action = new DeleteQueueAction(this.serviceClient, this.credentials, this.endpoint);
        DeleteQueueRequest request = new DeleteQueueRequest();
        request.setRequestPath(this.queueURL);
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public QueueMeta getAttributes() throws ServiceException, ClientException {
        GetQueueAttrAction action = new GetQueueAttrAction(this.serviceClient, this.credentials, this.endpoint);
        GetQueueAttrRequest request = new GetQueueAttrRequest();
        request.setRequestPath(this.queueURL);
        QueueMeta meta = (QueueMeta)action.executeWithCustomHeaders(request, this.customHeaders);
        meta.setQueueURL(this.queueURL);
        return meta;
    }

    public void setAttributes(QueueMeta queueMeta) throws ClientException, ServiceException {
        SetQueueAttrAction action = new SetQueueAttrAction(this.serviceClient, this.credentials, this.endpoint);
        SetQueueAttrRequest request = new SetQueueAttrRequest();
        request.setQueueMeta(queueMeta);
        request.setRequestPath("queues/" + queueMeta.getQueueName());
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public Message peekMessage() throws ServiceException, ClientException {
        PeekMessageAction action = new PeekMessageAction(this.serviceClient, this.credentials, this.endpoint);
        PeekMessageRequest request = new PeekMessageRequest();
        request.setRequestPath(this.queueURL);
        try {
            return (Message)action.executeWithCustomHeaders(request, this.customHeaders);
        }
        catch (ServiceException e) {
            if (!this.isMessageNotExist(e)) {
                throw e;
            }
            return null;
        }
    }

    public AsyncResult<Message> asyncPeekMessage(AsyncCallback<Message> callback) throws ClientException {
        PeekMessageAction action = new PeekMessageAction(this.serviceClient, this.credentials, this.endpoint);
        PeekMessageRequest request = new PeekMessageRequest();
        request.setRequestPath(this.queueURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public List<Message> batchPeekMessage(int batchSize) throws ServiceException, ClientException {
        BatchPeekMessageAction action = new BatchPeekMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchPeekMessageRequest request = new BatchPeekMessageRequest();
        request.setBatchSize(batchSize);
        request.setRequestPath(this.queueURL);
        try {
            return (List)action.executeWithCustomHeaders(request, this.customHeaders);
        }
        catch (ServiceException e) {
            if (!this.isMessageNotExist(e)) {
                throw e;
            }
            return null;
        }
    }

    public AsyncResult<List<Message>> asyncBatchPeekMessage(int batchSize, AsyncCallback<List<Message>> callback) throws ClientException {
        BatchPeekMessageAction action = new BatchPeekMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchPeekMessageRequest request = new BatchPeekMessageRequest();
        request.setBatchSize(batchSize);
        request.setRequestPath(this.queueURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public String changeMessageVisibilityTimeout(String receiptHandle, int visibilityTimeout) throws ServiceException, ClientException {
        ChangeVisibilityTimeoutAction action = new ChangeVisibilityTimeoutAction(this.serviceClient, this.credentials, this.endpoint);
        ChangeVisibilityTimeoutRequest request = new ChangeVisibilityTimeoutRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        request.setVisibilityTimeout(visibilityTimeout);
        return (String)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<String> asyncChangeMessageVisibilityTimeout(String receiptHandle, int visibilityTimeout, AsyncCallback<String> callback) throws ClientException {
        ChangeVisibilityTimeoutAction action = new ChangeVisibilityTimeoutAction(this.serviceClient, this.credentials, this.endpoint);
        ChangeVisibilityTimeoutRequest request = new ChangeVisibilityTimeoutRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        request.setVisibilityTimeout(visibilityTimeout);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public Message changeMessageVisibility(String receiptHandle, int visibilityTimeout) throws ServiceException, ClientException {
        ChangeVisibilityAction action = new ChangeVisibilityAction(this.serviceClient, this.credentials, this.endpoint);
        ChangeVisibilityTimeoutRequest request = new ChangeVisibilityTimeoutRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        request.setVisibilityTimeout(visibilityTimeout);
        return (Message)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<Message> asyncChangeMessageVisibility(String receiptHandle, int visibilityTimeout, AsyncCallback<Message> callback) throws ClientException {
        ChangeVisibilityAction action = new ChangeVisibilityAction(this.serviceClient, this.credentials, this.endpoint);
        ChangeVisibilityTimeoutRequest request = new ChangeVisibilityTimeoutRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        request.setVisibilityTimeout(visibilityTimeout);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public Message popMessage() throws ServiceException, ClientException {
        ReceiveMessageAction action = new ReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        ReceiveMessageRequest request = new ReceiveMessageRequest();
        request.setRequestPath(this.queueURL);
        try {
            return (Message)action.executeWithCustomHeaders(request, this.customHeaders);
        }
        catch (ServiceException e) {
            if (!this.isMessageNotExist(e)) {
                throw e;
            }
            return null;
        }
    }

    public Message popMessage(int waitSeconds) throws ServiceException, ClientException {
        ReceiveMessageAction action = new ReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        ReceiveMessageRequest request = new ReceiveMessageRequest();
        request.setRequestPath(this.queueURL);
        request.setWaitSeconds(waitSeconds);
        try {
            return (Message)action.executeWithCustomHeaders(request, this.customHeaders);
        }
        catch (ServiceException e) {
            if (!this.isMessageNotExist(e)) {
                throw e;
            }
            return null;
        }
    }

    public AsyncResult<Message> asyncPopMessage(AsyncCallback<Message> callback) throws ClientException {
        ReceiveMessageAction action = new ReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        ReceiveMessageRequest request = new ReceiveMessageRequest();
        request.setRequestPath(this.queueURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public AsyncResult<Message> asyncPopMessage(int waitSeconds, AsyncCallback<Message> callback) throws ClientException {
        ReceiveMessageAction action = new ReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        ReceiveMessageRequest request = new ReceiveMessageRequest();
        request.setRequestPath(this.queueURL);
        request.setWaitSeconds(waitSeconds);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public List<Message> batchPopMessage(int batchSize) throws ServiceException, ClientException {
        BatchReceiveMessageAction action = new BatchReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchReceiveMessageRequest request = new BatchReceiveMessageRequest();
        request.setBatchSize(batchSize);
        request.setRequestPath(this.queueURL);
        try {
            return (List)action.executeWithCustomHeaders(request, this.customHeaders);
        }
        catch (ServiceException e) {
            if (!this.isMessageNotExist(e)) {
                throw e;
            }
            return null;
        }
    }

    public List<Message> batchPopMessage(int batchSize, int waitSeconds) throws ServiceException, ClientException {
        BatchReceiveMessageAction action = new BatchReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchReceiveMessageRequest request = new BatchReceiveMessageRequest();
        request.setBatchSize(batchSize);
        request.setWaitSeconds(waitSeconds);
        request.setRequestPath(this.queueURL);
        try {
            return (List)action.executeWithCustomHeaders(request, this.customHeaders);
        }
        catch (ServiceException e) {
            if (!this.isMessageNotExist(e)) {
                throw e;
            }
            return null;
        }
    }

    public AsyncResult<List<Message>> asyncBatchPopMessage(int batchSize, AsyncCallback<List<Message>> callback) throws ClientException {
        BatchReceiveMessageAction action = new BatchReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchReceiveMessageRequest request = new BatchReceiveMessageRequest();
        request.setBatchSize(batchSize);
        request.setRequestPath(this.queueURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public AsyncResult<List<Message>> asyncBatchPopMessage(int batchSize, int waitSeconds, AsyncCallback<List<Message>> callback) throws ClientException {
        BatchReceiveMessageAction action = new BatchReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchReceiveMessageRequest request = new BatchReceiveMessageRequest();
        request.setBatchSize(batchSize);
        request.setWaitSeconds(waitSeconds);
        request.setRequestPath(this.queueURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public void deleteMessage(String receiptHandle) throws ServiceException, ClientException {
        DeleteMessageAction action = new DeleteMessageAction(this.serviceClient, this.credentials, this.endpoint);
        DeleteMessageRequest request = new DeleteMessageRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<Void> asyncDeleteMessage(String receiptHandle, AsyncCallback<Void> callback) throws ClientException {
        DeleteMessageAction action = new DeleteMessageAction(this.serviceClient, this.credentials, this.endpoint);
        DeleteMessageRequest request = new DeleteMessageRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public void batchDeleteMessage(List<String> receiptHandles) throws ServiceException, ClientException {
        BatchDeleteMessageAction action = new BatchDeleteMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchDeleteMessageRequest request = new BatchDeleteMessageRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandles(receiptHandles);
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<Void> asyncBatchDeleteMessage(List<String> receiptHandles, AsyncCallback<Void> callback) throws ClientException {
        BatchDeleteMessageAction action = new BatchDeleteMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchDeleteMessageRequest request = new BatchDeleteMessageRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandles(receiptHandles);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public Message putMessage(Message message) throws ServiceException, ClientException {
        SendMessageAction action = new SendMessageAction(this.serviceClient, this.credentials, this.endpoint);
        SendMessageRequest request = new SendMessageRequest();
        request.setMessage(message);
        request.setRequestPath(this.queueURL);
        return (Message)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<Message> asyncPutMessage(Message message, AsyncCallback<Message> callback) throws ClientException {
        SendMessageAction action = new SendMessageAction(this.serviceClient, this.credentials, this.endpoint);
        SendMessageRequest request = new SendMessageRequest();
        request.setMessage(message);
        request.setRequestPath(this.queueURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public List<Message> batchPutMessage(List<Message> messages) throws ServiceException, ClientException {
        BatchSendMessageAction action = new BatchSendMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchSendMessageRequest request = new BatchSendMessageRequest();
        request.setMessages(messages);
        request.setRequestPath(this.queueURL);
        return (List)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    public AsyncResult<List<Message>> asyncBatchPutMessage(List<Message> messages, AsyncCallback<List<Message>> callback) throws ClientException {
        BatchSendMessageAction action = new BatchSendMessageAction(this.serviceClient, this.credentials, this.endpoint);
        BatchSendMessageRequest request = new BatchSendMessageRequest();
        request.setMessages(messages);
        request.setRequestPath(this.queueURL);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    public String getQueueURL() {
        return this.queueURL;
    }

    public boolean isMessageNotExist(ServiceException e) {
        return "MessageNotExist".equals(e.getErrorCode());
    }

    public boolean isQueueExist() throws ServiceException, ClientException {
        boolean res = false;
        try {
            this.getAttributes();
            res = true;
        }
        catch (ServiceException se) {
            if (se.getErrorCode().equals("QueueNotExist")) {
                res = false;
            }
            throw se;
        }
        return res;
    }
}

