/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractMojoBase;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractEpubMojo
extends AbstractMojoBase {
    private ZipArchiver zipArchiver;
    private File targetFile;

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        String rootFilename = targetFile.getName();
        rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
        transformer.setParameter("root.filename", rootFilename);
        transformer.setParameter("base.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("epub.oebps.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("epub.metainf.dir", targetFile.getParent() + File.separator + "META-INF" + File.separator);
        this.validateFont();
        this.targetFile = targetFile;
    }

    public void postProcess() throws MojoExecutionException {
        super.postProcess();
        try {
            URL containerURL = ((Object)((Object)this)).getClass().getResource("/epub/container.xml");
            FileUtils.copyURLToFile((URL)containerURL, (File)new File(this.targetFile.getParentFile(), "META-INF" + File.separator + "container.xml"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy hardcoded container.xml file", (Exception)e);
        }
        try {
            URL mimetypeURL = ((Object)((Object)this)).getClass().getResource("/epub/mimetype");
            FileUtils.copyURLToFile((URL)mimetypeURL, (File)new File(this.targetFile.getParentFile(), "mimetype"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy hardcoded mimetype file", (Exception)e);
        }
        try {
            this.zipArchiver.addDirectory(this.targetFile.getParentFile());
            this.zipArchiver.setCompress(true);
            this.zipArchiver.setDestFile(this.targetFile);
            this.zipArchiver.createArchive();
            this.getLog().debug((CharSequence)("epub file created at: " + this.zipArchiver.getDestFile().getAbsolutePath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to zip epub file", e);
        }
    }

    private void validateFont() {
        String font = this.getProperty("epubEmbeddedFont");
        if (font != null) {
            File f = new File(font);
            if (!f.exists()) {
                this.getLog().warn((CharSequence)("Unable to find specified font: " + f.getAbsolutePath()));
            }
            if (!font.endsWith("otf")) {
                this.getLog().warn((CharSequence)("Only otf font is supported: " + font));
            }
        }
    }
}

