/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.maven.docbkx;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public class ZipFileProcessor {
    private File file;

    public ZipFileProcessor(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ZipEntryVisitor visitor) throws IOException {
        InputStream in = null;
        ZipInputStream zipIn = null;
        try {
            in = new FileInputStream(this.file);
            in = new BufferedInputStream(in);
            zipIn = new ZipInputStream(in);
            ZipEntry entry = null;
            while ((entry = zipIn.getNextEntry()) != null) {
                visitor.visit(entry, new SafeZipEntryInputStream(entry, zipIn));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipIn);
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zipIn);
        IOUtils.closeQuietly((InputStream)in);
    }

    private static class SafeZipEntryInputStream
    extends InputStream {
        private int pos = 0;
        private long size;
        private ZipInputStream in;

        public SafeZipEntryInputStream(ZipEntry entry, ZipInputStream in) {
            this.size = entry.getCompressedSize();
            this.in = in;
        }

        public int read() throws IOException {
            if ((long)this.pos >= this.size) {
                return -1;
            }
            return this.in.read();
        }
    }

    public static interface ZipEntryVisitor {
        public void visit(ZipEntry var1, InputStream var2) throws IOException;
    }
}

