/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.photos;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.util.StringUtilities;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;

public class SearchParameters {
    private String userId;
    private String groupId;
    private String woeId;
    private String media;
    private String contacts;
    private String[] tags;
    private String tagMode;
    private String text;
    private Date minUploadDate;
    private Date maxUploadDate;
    private Date minTakenDate;
    private Date maxTakenDate;
    private Date interestingnessDate;
    private String license;
    private boolean extrasLicense = false;
    private boolean extrasDateUpload = false;
    private boolean extrasDateTaken = false;
    private boolean extrasOwnerName = false;
    private boolean extrasIconServer = false;
    private boolean extrasOriginalFormat = true;
    private boolean extrasLastUpdate = false;
    private boolean extrasGeo = false;
    private boolean extrasTags = false;
    private boolean extrasMachineTags = false;
    private String[] bbox;
    private String placeId;
    private int accuracy = 0;
    private String safeSearch;
    private String[] machineTags;
    private String machineTagMode;
    private static final ThreadLocal DATE_FORMATS = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal MYSQL_DATE_FORMATS = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static int DATE_POSTED_DESC = 0;
    public static int DATE_POSTED_ASC = 1;
    public static int DATE_TAKEN_DESC = 2;
    public static int DATE_TAKEN_ASC = 3;
    public static int INTERESTINGNESS_DESC = 4;
    public static int INTERESTINGNESS_ASC = 5;
    public static int RELEVANCE = 6;
    private int sort = 0;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public String getTagMode() {
        return this.tagMode;
    }

    public void setTagMode(String tagMode) {
        this.tagMode = tagMode;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getMinUploadDate() {
        return this.minUploadDate;
    }

    public void setMinUploadDate(Date minUploadDate) {
        this.minUploadDate = minUploadDate;
    }

    public Date getMaxUploadDate() {
        return this.maxUploadDate;
    }

    public void setMaxUploadDate(Date maxUploadDate) {
        this.maxUploadDate = maxUploadDate;
    }

    public Date getMinTakenDate() {
        return this.minTakenDate;
    }

    public void setMinTakenDate(Date minTakenDate) {
        this.minTakenDate = minTakenDate;
    }

    public Date getMaxTakenDate() {
        return this.maxTakenDate;
    }

    public void setMaxTakenDate(Date maxTakenDate) {
        this.maxTakenDate = maxTakenDate;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public Date getInterestingnessDate() {
        return this.interestingnessDate;
    }

    public void setInterestingnessDate(Date intrestingnessDate) {
        this.interestingnessDate = intrestingnessDate;
    }

    public void setMachineTags(String[] tags) {
        this.machineTags = tags;
    }

    public String[] getMachineTags() {
        return this.machineTags;
    }

    public void setMachineTagMode(String tagMode) {
        this.machineTagMode = tagMode;
    }

    public String getMachineTagMode() {
        return this.machineTagMode;
    }

    public void setExtras(boolean toggle) {
        this.setExtrasLicense(toggle);
        this.setExtrasDateUpload(toggle);
        this.setExtrasDateTaken(toggle);
        this.setExtrasOwnerName(toggle);
        this.setExtrasIconServer(toggle);
        this.setExtrasOriginalFormat(toggle);
        this.setExtrasLastUpdate(toggle);
        this.setExtrasGeo(toggle);
        this.setExtrasTags(toggle);
        this.setExtrasMachineTags(toggle);
    }

    public void setExtrasLicense(boolean toggle) {
        this.extrasLicense = toggle;
    }

    public void setExtrasDateUpload(boolean toggle) {
        this.extrasDateUpload = toggle;
    }

    public void setExtrasDateTaken(boolean toggle) {
        this.extrasDateTaken = toggle;
    }

    public void setExtrasOwnerName(boolean toggle) {
        this.extrasOwnerName = toggle;
    }

    public void setExtrasIconServer(boolean toggle) {
        this.extrasIconServer = toggle;
    }

    public void setExtrasOriginalFormat(boolean toggle) {
        this.extrasOriginalFormat = toggle;
    }

    public void setExtrasGeo(boolean extrasGeo) {
        this.extrasGeo = extrasGeo;
    }

    public void setExtrasLastUpdate(boolean extrasLastUpdate) {
        this.extrasLastUpdate = extrasLastUpdate;
    }

    public void setExtrasMachineTags(boolean extrasMachineTags) {
        this.extrasMachineTags = extrasMachineTags;
    }

    public void setExtrasTags(boolean extrasTags) {
        this.extrasTags = extrasTags;
    }

    public void setBBox(String minimum_longitude, String minimum_latitude, String maximum_longitude, String maximum_latitude) {
        this.bbox = new String[]{minimum_longitude, minimum_latitude, maximum_longitude, maximum_latitude};
    }

    public String[] getBBox() {
        return this.bbox;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setSafeSearch(String level) {
        this.safeSearch = level;
    }

    public String getSafeSearch() {
        return this.safeSearch;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int order) {
        this.sort = order;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public String getWoeId() {
        return this.woeId;
    }

    public void setWoeId(String woeId) {
        this.woeId = woeId;
    }

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) throws FlickrException {
        if (!(media.equals("all") || media.equals("photos") || media.equals("videos"))) {
            throw new FlickrException("0", "Media type is not valid.");
        }
        this.media = media;
    }

    public String getContacts() {
        return this.contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public Collection getAsParameters() {
        String safeSearch;
        String[] bbox;
        Date intrestingnessDate;
        String license;
        Date maxTakenDate;
        Date minTakenDate;
        Date maxUploadDate;
        Date minUploadDate;
        String text;
        String mtagMode;
        String[] mtags;
        String tagMode;
        String[] tags;
        String groupId;
        String userId;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String media = this.getMedia();
        if (media != null) {
            parameters.add(new Parameter("media", media));
        }
        if ((userId = this.getUserId()) != null) {
            parameters.add(new Parameter("user_id", userId));
            String contacts = this.getContacts();
            if (contacts != null) {
                parameters.add(new Parameter("contacts", contacts));
            }
        }
        if ((groupId = this.getGroupId()) != null) {
            parameters.add(new Parameter("group_id", groupId));
        }
        if ((tags = this.getTags()) != null) {
            parameters.add(new Parameter("tags", StringUtilities.join(tags, ",")));
        }
        if ((tagMode = this.getTagMode()) != null) {
            parameters.add(new Parameter("tag_mode", tagMode));
        }
        if ((mtags = this.getMachineTags()) != null) {
            parameters.add(new Parameter("machine_tags", StringUtilities.join(mtags, ",")));
        }
        if ((mtagMode = this.getMachineTagMode()) != null) {
            parameters.add(new Parameter("machine_tag_mode", mtagMode));
        }
        if ((text = this.getText()) != null) {
            parameters.add(new Parameter("text", text));
        }
        if ((minUploadDate = this.getMinUploadDate()) != null) {
            parameters.add(new Parameter("min_upload_date", new Long(minUploadDate.getTime() / 1000L)));
        }
        if ((maxUploadDate = this.getMaxUploadDate()) != null) {
            parameters.add(new Parameter("max_upload_date", new Long(maxUploadDate.getTime() / 1000L)));
        }
        if ((minTakenDate = this.getMinTakenDate()) != null) {
            parameters.add(new Parameter("min_taken_date", ((DateFormat)MYSQL_DATE_FORMATS.get()).format(minTakenDate)));
        }
        if ((maxTakenDate = this.getMaxTakenDate()) != null) {
            parameters.add(new Parameter("max_taken_date", ((DateFormat)MYSQL_DATE_FORMATS.get()).format(maxTakenDate)));
        }
        if ((license = this.getLicense()) != null) {
            parameters.add(new Parameter("license", license));
        }
        if ((intrestingnessDate = this.getInterestingnessDate()) != null) {
            parameters.add(new Parameter("date", ((DateFormat)DATE_FORMATS.get()).format(intrestingnessDate)));
        }
        if ((bbox = this.getBBox()) != null) {
            parameters.add(new Parameter("bbox", StringUtilities.join(bbox, ",")));
            if (this.accuracy > 0) {
                parameters.add(new Parameter("accuracy", this.accuracy));
            }
        } else {
            String woeId = this.getWoeId();
            if (woeId != null) {
                parameters.add(new Parameter("woe_id", woeId));
            }
        }
        if ((safeSearch = this.getSafeSearch()) != null) {
            parameters.add(new Parameter("safe_search", safeSearch));
        }
        if (this.extrasLicense || this.extrasDateUpload || this.extrasDateTaken || this.extrasOwnerName || this.extrasIconServer || this.extrasOriginalFormat || this.extrasLastUpdate || this.extrasGeo || this.extrasTags || this.extrasMachineTags) {
            Vector<String> argsList = new Vector<String>();
            if (this.extrasLicense) {
                argsList.add("license");
            }
            if (this.extrasDateUpload) {
                argsList.add("date_upload");
            }
            if (this.extrasDateTaken) {
                argsList.add("date_taken");
            }
            if (this.extrasOwnerName) {
                argsList.add("owner_name");
            }
            if (this.extrasIconServer) {
                argsList.add("icon_server");
            }
            if (this.extrasOriginalFormat) {
                argsList.add("original_format");
            }
            if (this.extrasLastUpdate) {
                argsList.add("last_update");
            }
            if (this.extrasGeo) {
                argsList.add("geo");
            }
            if (this.extrasTags) {
                argsList.add("tags");
            }
            if (this.extrasMachineTags) {
                argsList.add("machine_tags");
            }
            parameters.add(new Parameter("extras", StringUtilities.join(argsList, ",")));
        }
        if (this.sort != DATE_POSTED_DESC) {
            String sortArg = null;
            if (this.sort == DATE_POSTED_ASC) {
                sortArg = "date-posted-asc";
            }
            if (this.sort == DATE_TAKEN_DESC) {
                sortArg = "date-taken-desc";
            }
            if (this.sort == DATE_TAKEN_ASC) {
                sortArg = "date-taken-asc";
            }
            if (this.sort == INTERESTINGNESS_DESC) {
                sortArg = "interestingness-desc";
            }
            if (this.sort == INTERESTINGNESS_ASC) {
                sortArg = "interestingness-asc";
            }
            if (this.sort == RELEVANCE) {
                sortArg = "relevance";
            }
            if (sortArg != null) {
                parameters.add(new Parameter("sort", sortArg));
            }
        }
        return parameters;
    }
}

