/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.controller;

import cn.ponfee.scheduler.common.base.model.Result;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.enums.JobState;
import cn.ponfee.scheduler.core.enums.Operations;
import cn.ponfee.scheduler.core.enums.RunState;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.supervisor.manager.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api"})
public class ApiController {
    private static final Logger LOG = LoggerFactory.getLogger(ApiController.class);
    private final JobManager jobManager;

    public ApiController(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    @PostMapping(value={"job/add"})
    public Result<Void> addJob(@RequestBody SchedJob job) {
        this.jobManager.addJob(job);
        return Result.success();
    }

    @PutMapping(value={"job/update"})
    public Result<Void> updateJob(@RequestBody SchedJob job) {
        LOG.info("Do updating sched job {}", (Object)job.getJobId());
        this.jobManager.updateJob(job);
        return Result.success();
    }

    @DeleteMapping(value={"job/delete"})
    public Result<Void> deleteJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do deleting sched job {}", (Object)jobId);
        this.jobManager.deleteJob(jobId);
        return Result.success();
    }

    @GetMapping(value={"job/get"})
    public Result<SchedJob> getJob(@RequestParam(value="jobId") long jobId) {
        return Result.success((Object)this.jobManager.getJob(jobId));
    }

    @PostMapping(value={"job/stop"})
    public Result<Boolean> stopJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do stopping sched job {}", (Object)jobId);
        return Result.success((Object)this.jobManager.changeJobState(jobId, JobState.STOPPED));
    }

    @PostMapping(value={"job/start"})
    public Result<Boolean> startJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do starting sched job {}", (Object)jobId);
        return Result.success((Object)this.jobManager.changeJobState(jobId, JobState.STARTED));
    }

    @PostMapping(value={"job/manual_trigger"})
    public Result<Void> manualTriggerJob(@RequestParam(value="jobId") long jobId) throws JobException {
        LOG.info("Do triggering sched job {}", (Object)jobId);
        this.jobManager.manualTrigger(jobId);
        return Result.success();
    }

    @PostMapping(value={"track/pause"})
    public Result<Boolean> pauseTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do pausing sched track {}", (Object)trackId);
        return Result.success((Object)this.jobManager.pauseTrack(trackId));
    }

    @PostMapping(value={"track/cancel"})
    public Result<Boolean> cancelTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do canceling sched track {}", (Object)trackId);
        return Result.success((Object)this.jobManager.cancelTrack(trackId, Operations.MANUAL_CANCEL));
    }

    @PostMapping(value={"track/resume"})
    public Result<Boolean> resumeTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do resuming sched track {}", (Object)trackId);
        return Result.success((Object)this.jobManager.resume(trackId));
    }

    @PutMapping(value={"track/fupdate_state"})
    public Result<Void> forceUpdateTrackState(@RequestParam(value="trackId") long trackId, @RequestParam(value="trackTargetState") int trackTargetState, @RequestParam(value="taskTargetState") int taskTargetState) {
        RunState.of((Integer)trackTargetState);
        ExecuteState.of((Integer)taskTargetState);
        LOG.info("Do force update sched track state {} - {} - {}", new Object[]{trackId, trackTargetState, taskTargetState});
        this.jobManager.forceUpdateState(trackId, trackTargetState, taskTargetState);
        return Result.success();
    }

    @PostMapping(value={"track/fresume"})
    public Result<Void> forceResumeTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do force resuming sched track {}", (Object)trackId);
        this.jobManager.forceUpdateState(trackId, RunState.WAITING.value(), ExecuteState.WAITING.value());
        return Result.success();
    }

    @DeleteMapping(value={"track/delete"})
    public Result<Void> deleteTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do deleting sched track {}", (Object)trackId);
        this.jobManager.deleteTrack(trackId);
        return Result.success();
    }

    @GetMapping(value={"track/get"})
    public Result<Object[]> getTrack(@RequestParam(value="trackId") long trackId) {
        return Result.success((Object)new Object[]{this.jobManager.getTrack(trackId), this.jobManager.getTasks(trackId)});
    }
}

