/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.base;

import cn.ponfee.scheduler.common.util.ClassUtils;
import java.text.MessageFormat;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractDataSourceConfig {
    private final String mapperFileLocation;

    public AbstractDataSourceConfig() {
        String basePackage = ClassUtils.getPackagePath(this.getClass());
        this.mapperFileLocation = MessageFormat.format("classpath*:{0}xml/*.xml", basePackage);
    }

    public AbstractDataSourceConfig(String mapperFileLocation) {
        this.mapperFileLocation = mapperFileLocation;
    }

    public abstract DataSource dataSource();

    protected final SqlSessionFactory createSqlSessionFactory() throws Exception {
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setDataSource(this.dataSource());
        factoryBean.setConfigLocation((Resource)new ClassPathResource("mybatis-config.xml"));
        factoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(this.mapperFileLocation));
        return factoryBean.getObject();
    }
}

