/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.aws.request;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import vc.inreach.aws.request.AWSSigner;

public class AWSSigningRequestInterceptor
implements HttpRequestInterceptor {
    private static final Splitter SPLITTER = Splitter.on((char)'&').trimResults().omitEmptyStrings();
    private final AWSSigner signer;
    private static final Function<HttpEntity, byte[]> TO_BYTE_ARRAY = entity -> {
        try {
            return ByteStreams.toByteArray((InputStream)entity.getContent());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    };

    public AWSSigningRequestInterceptor(AWSSigner signer) {
        this.signer = signer;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        request.setHeaders(this.headers(this.signer.getSignedHeaders(this.path(request), request.getRequestLine().getMethod(), this.params(request), this.headers(request), this.body(request))));
    }

    private Multimap<String, String> params(HttpRequest request) throws IOException {
        String rawQuery = ((HttpRequestWrapper)request).getURI().getRawQuery();
        if (Strings.isNullOrEmpty((String)rawQuery)) {
            return ImmutableListMultimap.of();
        }
        return this.params(URLDecoder.decode(rawQuery, StandardCharsets.UTF_8.name()));
    }

    private Multimap<String, String> params(String query) {
        ImmutableListMultimap.Builder queryParams = ImmutableListMultimap.builder();
        if (!Strings.isNullOrEmpty((String)query)) {
            for (String pair : SPLITTER.split((CharSequence)query)) {
                int index = pair.indexOf(61);
                if (index > 0 && pair.length() > index + 1) {
                    String key = pair.substring(0, index);
                    String value = pair.substring(index + 1);
                    queryParams.put((Object)key, (Object)value);
                    continue;
                }
                if (pair.length() <= 0) continue;
                queryParams.put((Object)pair, (Object)"");
            }
        }
        return queryParams.build();
    }

    private String path(HttpRequest request) {
        return ((HttpRequestWrapper)request).getURI().getRawPath();
    }

    private Map<String, Object> headers(HttpRequest request) {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        for (Header header : request.getAllHeaders()) {
            headers.put((Object)header.getName(), (Object)header.getValue());
        }
        return headers.build();
    }

    private Optional<byte[]> body(HttpRequest request) throws IOException {
        HttpRequest original = ((HttpRequestWrapper)request).getOriginal();
        if (!HttpEntityEnclosingRequest.class.isAssignableFrom(original.getClass())) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)((HttpEntityEnclosingRequest)original).getEntity()).transform(TO_BYTE_ARRAY);
    }

    private Header[] headers(Map<String, Object> from) {
        return from.entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), entry.getValue().toString())).collect(Collectors.toList()).toArray(new Header[from.size()]);
    }
}

