/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbClusterAutomatedBackupsRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeDbClusterAutomatedBackupsRequest.Builder, DescribeDbClusterAutomatedBackupsRequest> {
    private static final SdkField<String> DB_CLUSTER_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterResourceId").getter(getter(DescribeDbClusterAutomatedBackupsRequest::dbClusterResourceId))
            .setter(setter(Builder::dbClusterResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterResourceId").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DescribeDbClusterAutomatedBackupsRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeDbClusterAutomatedBackupsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeDbClusterAutomatedBackupsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbClusterAutomatedBackupsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_RESOURCE_ID_FIELD,
            DB_CLUSTER_IDENTIFIER_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String dbClusterResourceId;

    private final String dbClusterIdentifier;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private DescribeDbClusterAutomatedBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The resource ID of the DB cluster that is the source of the automated backup. This parameter isn't
     * case-sensitive.
     * </p>
     * 
     * @return The resource ID of the DB cluster that is the source of the automated backup. This parameter isn't
     *         case-sensitive.
     */
    public final String dbClusterResourceId() {
        return dbClusterResourceId;
    }

    /**
     * <p>
     * (Optional) The user-supplied DB cluster identifier. If this parameter is specified, it must match the identifier
     * of an existing DB cluster. It returns information from the specific DB cluster's automated backup. This parameter
     * isn't case-sensitive.
     * </p>
     * 
     * @return (Optional) The user-supplied DB cluster identifier. If this parameter is specified, it must match the
     *         identifier of an existing DB cluster. It returns information from the specific DB cluster's automated
     *         backup. This parameter isn't case-sensitive.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter that specifies which resources to return based on status.
     * </p>
     * <p>
     * Supported filters are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>status</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>retained</code> - Automated backups for deleted clusters and after backup replication is stopped.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db-cluster-id</code> - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The results list
     * includes only information about the DB cluster automated backups identified by these ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db-cluster-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The
     * results list includes only information about the DB cluster resources identified by these ARNs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Returns all resources by default. The status for each resource is specified in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A filter that specifies which resources to return based on status.</p>
     *         <p>
     *         Supported filters are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>status</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>retained</code> - Automated backups for deleted clusters and after backup replication is stopped.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db-cluster-id</code> - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The results
     *         list includes only information about the DB cluster automated backups identified by these ARNs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db-cluster-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs).
     *         The results list includes only information about the DB cluster resources identified by these ARNs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Returns all resources by default. The status for each resource is specified in the response.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
     * retrieve the remaining results.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you
     *         can retrieve the remaining results.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The pagination token provided in the previous request. If this parameter is specified the response includes only
     * records beyond the marker, up to <code>MaxRecords</code>.
     * </p>
     * 
     * @return The pagination token provided in the previous request. If this parameter is specified the response
     *         includes only records beyond the marker, up to <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterAutomatedBackupsRequest)) {
            return false;
        }
        DescribeDbClusterAutomatedBackupsRequest other = (DescribeDbClusterAutomatedBackupsRequest) obj;
        return Objects.equals(dbClusterResourceId(), other.dbClusterResourceId())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbClusterAutomatedBackupsRequest").add("DbClusterResourceId", dbClusterResourceId())
                .add("DBClusterIdentifier", dbClusterIdentifier()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbClusterResourceId":
            return Optional.ofNullable(clazz.cast(dbClusterResourceId()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterAutomatedBackupsRequest, T> g) {
        return obj -> g.apply((DescribeDbClusterAutomatedBackupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbClusterAutomatedBackupsRequest> {
        /**
         * <p>
         * The resource ID of the DB cluster that is the source of the automated backup. This parameter isn't
         * case-sensitive.
         * </p>
         * 
         * @param dbClusterResourceId
         *        The resource ID of the DB cluster that is the source of the automated backup. This parameter isn't
         *        case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterResourceId(String dbClusterResourceId);

        /**
         * <p>
         * (Optional) The user-supplied DB cluster identifier. If this parameter is specified, it must match the
         * identifier of an existing DB cluster. It returns information from the specific DB cluster's automated backup.
         * This parameter isn't case-sensitive.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        (Optional) The user-supplied DB cluster identifier. If this parameter is specified, it must match the
         *        identifier of an existing DB cluster. It returns information from the specific DB cluster's automated
         *        backup. This parameter isn't case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * A filter that specifies which resources to return based on status.
         * </p>
         * <p>
         * Supported filters are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>retained</code> - Automated backups for deleted clusters and after backup replication is stopped.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>db-cluster-id</code> - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB cluster automated backups identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-cluster-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The
         * results list includes only information about the DB cluster resources identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Returns all resources by default. The status for each resource is specified in the response.
         * </p>
         * 
         * @param filters
         *        A filter that specifies which resources to return based on status.</p>
         *        <p>
         *        Supported filters are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>retained</code> - Automated backups for deleted clusters and after backup replication is
         *        stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-cluster-id</code> - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The
         *        results list includes only information about the DB cluster automated backups identified by these
         *        ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-cluster-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names
         *        (ARNs). The results list includes only information about the DB cluster resources identified by these
         *        ARNs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Returns all resources by default. The status for each resource is specified in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * A filter that specifies which resources to return based on status.
         * </p>
         * <p>
         * Supported filters are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>retained</code> - Automated backups for deleted clusters and after backup replication is stopped.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>db-cluster-id</code> - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB cluster automated backups identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-cluster-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The
         * results list includes only information about the DB cluster resources identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Returns all resources by default. The status for each resource is specified in the response.
         * </p>
         * 
         * @param filters
         *        A filter that specifies which resources to return based on status.</p>
         *        <p>
         *        Supported filters are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>retained</code> - Automated backups for deleted clusters and after backup replication is
         *        stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-cluster-id</code> - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The
         *        results list includes only information about the DB cluster automated backups identified by these
         *        ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-cluster-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names
         *        (ARNs). The results list includes only information about the DB cluster resources identified by these
         *        ARNs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Returns all resources by default. The status for each resource is specified in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * A filter that specifies which resources to return based on status.
         * </p>
         * <p>
         * Supported filters are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>retained</code> - Automated backups for deleted clusters and after backup replication is stopped.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>db-cluster-id</code> - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The results
         * list includes only information about the DB cluster automated backups identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-cluster-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The
         * results list includes only information about the DB cluster resources identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Returns all resources by default. The status for each resource is specified in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
         * retrieve the remaining results.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
         *        you can retrieve the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The pagination token provided in the previous request. If this parameter is specified the response includes
         * only records beyond the marker, up to <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        The pagination token provided in the previous request. If this parameter is specified the response
         *        includes only records beyond the marker, up to <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbClusterResourceId;

        private String dbClusterIdentifier;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterAutomatedBackupsRequest model) {
            super(model);
            dbClusterResourceId(model.dbClusterResourceId);
            dbClusterIdentifier(model.dbClusterIdentifier);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getDbClusterResourceId() {
            return dbClusterResourceId;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbClusterAutomatedBackupsRequest build() {
            return new DescribeDbClusterAutomatedBackupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
