/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.ext;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.Extractors;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.ArtifactStore;
import de.flapdoodle.embed.process.store.IDownloader;
import java.io.File;
import java.io.IOException;
import ru.yandex.qatools.embed.postgresql.ext.EmptyFileSet;
import ru.yandex.qatools.embed.postgresql.ext.PostgresFilesToExtract;

public class PostgresArtifactStore
extends ArtifactStore {
    private IDownloadConfig _downloadConfig;
    private IDirectory _tempDirFactory;
    private ITempNaming _executableNaming;

    public PostgresArtifactStore(IDownloadConfig downloadConfig, IDirectory tempDirFactory, ITempNaming executableNaming, IDownloader downloader) {
        super(downloadConfig, tempDirFactory, executableNaming, downloader);
        this._downloadConfig = downloadConfig;
        this._tempDirFactory = tempDirFactory;
        this._executableNaming = executableNaming;
    }

    private File getArtifact(IDownloadConfig runtime, Distribution distribution) {
        File dir = this.createOrGetBaseDir(runtime);
        File artifactFile = new File(dir, runtime.getPackageResolver().getPath(distribution));
        if (artifactFile.exists() && artifactFile.isFile()) {
            return artifactFile;
        }
        return null;
    }

    private File createOrGetBaseDir(IDownloadConfig runtime) {
        File dir = runtime.getArtifactStorePath().asFile();
        this.createOrCheckDir(dir);
        return dir;
    }

    private void createOrCheckDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Could NOT create Directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("" + dir + " is not a Directory");
        }
    }

    public IDirectory getTempDir() {
        return this._tempDirFactory;
    }

    public void removeFileSet(Distribution distribution, IExtractedFileSet all) {
        try {
            super.removeFileSet(distribution, all);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Failed to remove file set: " + e.getMessage());
        }
    }

    public IDownloadConfig getDownloadConfig() {
        return this._downloadConfig;
    }

    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        IPackageResolver packageResolver = this._downloadConfig.getPackageResolver();
        File artifact = this.getArtifact(this._downloadConfig, distribution);
        ArchiveType archiveType = packageResolver.getArchiveType(distribution);
        IExtractor extractor = Extractors.getExtractor((ArchiveType)archiveType);
        try {
            FileSet fileSet = packageResolver.getFileSet(distribution);
            return extractor.extract(this._downloadConfig, artifact, (FilesToExtract)new PostgresFilesToExtract(this._tempDirFactory, this._executableNaming, fileSet));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failed to extract file set: " + e.getMessage());
            return new EmptyFileSet();
        }
    }
}

