/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractSingleProcessorMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinterMojo<T>
extends AbstractSingleProcessorMojo {
    private LintReport<T> lintReport;

    protected final void addReport(ResourceLintReport<T> report) {
        this.lintReport.addReport(report);
    }

    @Override
    protected void onBeforeExecute() {
        this.validateReportFormat();
        this.lintReport = new LintReport();
        FileUtils.deleteQuietly((File)this.getReportFile());
    }

    @Override
    protected void onAfterExecute() {
        if (this.shouldGenerateReport()) {
            try {
                this.getReportFile().getParentFile().mkdirs();
                this.getReportFile().createNewFile();
                this.getLog().debug((CharSequence)("creating report at location: " + this.getReportFile()));
                ReportXmlFormatter.FormatterType type = ReportXmlFormatter.FormatterType.getByFormat((String)this.getReportFormat());
                if (type != null) {
                    this.createXmlFormatter(this.lintReport, type).write((OutputStream)new FileOutputStream(this.getReportFile()));
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not create report file: " + this.getReportFile()), (Throwable)e);
            }
        }
    }

    protected abstract ReportXmlFormatter createXmlFormatter(LintReport<T> var1, ReportXmlFormatter.FormatterType var2);

    private void validateReportFormat() {
        if (ReportXmlFormatter.FormatterType.getByFormat((String)this.getReportFormat()) == null) {
            throw new WroRuntimeException("Usupported report format: " + this.getReportFormat() + ". Valid formats are: " + ReportXmlFormatter.FormatterType.getSupportedFormatsAsCSV());
        }
    }

    private boolean shouldGenerateReport() {
        return this.getReportFile() != null;
    }

    protected abstract File getReportFile();

    protected abstract String getReportFormat();

    void onException(Exception e) {
    }
}

