/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.as.clustering.controller.FunctionExecutor;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricFunction;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.ModClusterLoadBalancingGroupDefinition;
import org.wildfly.extension.undertow.filters.ModClusterNodeDefinition;
import org.wildfly.extension.undertow.filters.ModClusterServiceNameProvider;

class ModClusterBalancerDefinition
extends SimpleResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"balancer");
    private final FunctionExecutorRegistry<ModCluster> registry;

    ModClusterBalancerDefinition(FunctionExecutorRegistry<ModCluster> registry) {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver("filter", ModClusterDefinition.PATH_ELEMENT.getKey(), PATH_ELEMENT.getKey())).setRuntime());
        this.registry = registry;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new ModClusterNodeDefinition(this.registry));
        resourceRegistration.registerSubModel((ResourceDefinition)new ModClusterLoadBalancingGroupDefinition(this.registry));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        MetricHandler handler = new MetricHandler((MetricExecutor)new LoadBalancerMetricExecutor(this.registry), LoadBalancerMetric.class);
        for (LoadBalancerMetric metric : EnumSet.allOf(LoadBalancerMetric.class)) {
            resourceRegistration.registerReadOnlyAttribute(metric.getDefinition(), (OperationStepHandler)handler);
        }
    }

    static class LoadBalancerFunction
    implements Function<ModCluster, ModClusterStatus.LoadBalancer> {
        private final String balancerName;

        LoadBalancerFunction(String balancerName) {
            this.balancerName = balancerName;
        }

        @Override
        public ModClusterStatus.LoadBalancer apply(ModCluster service) {
            return service.getController().getStatus().getLoadBalancer(this.balancerName);
        }
    }

    static class LoadBalancerMetricExecutor
    implements MetricExecutor<ModClusterStatus.LoadBalancer> {
        private final FunctionExecutorRegistry<ModCluster> registry;

        LoadBalancerMetricExecutor(FunctionExecutorRegistry<ModCluster> registry) {
            this.registry = registry;
        }

        public ModelNode execute(OperationContext context, Metric<ModClusterStatus.LoadBalancer> metric) throws OperationFailedException {
            PathAddress balancerAddress = context.getCurrentAddress();
            String balancerName = balancerAddress.getLastElement().getValue();
            PathAddress serviceAddress = balancerAddress.getParent();
            FunctionExecutor executor = this.registry.get(new ModClusterServiceNameProvider(serviceAddress).getServiceName());
            return executor != null ? (ModelNode)executor.execute((ExceptionFunction)new MetricFunction((Function)new LoadBalancerFunction(balancerName), metric)) : null;
        }
    }

    static enum LoadBalancerMetric implements Metric<ModClusterStatus.LoadBalancer>
    {
        STICKY_SESSION_COOKIE("sticky-session-cookie", ModelType.STRING){

            public ModelNode execute(ModClusterStatus.LoadBalancer balancer) {
                return Optional.ofNullable(balancer.getStickySessionCookie()).map(ModelNode::new).orElse(null);
            }
        }
        ,
        STICKY_SESSION_PATH("sticky-session-path", ModelType.STRING){

            public ModelNode execute(ModClusterStatus.LoadBalancer balancer) {
                return Optional.ofNullable(balancer.getStickySessionPath()).map(ModelNode::new).orElse(null);
            }
        }
        ,
        MAX_ATTEMPTS("max-attempts", ModelType.INT){

            public ModelNode execute(ModClusterStatus.LoadBalancer balancer) {
                return new ModelNode(balancer.getMaxRetries());
            }
        }
        ,
        WAIT_WORKER("wait-worker", ModelType.INT){

            public ModelNode execute(ModClusterStatus.LoadBalancer balancer) {
                return new ModelNode(balancer.getWaitWorker());
            }
        }
        ,
        STICKY_SESSION("sticky-session", ModelType.BOOLEAN){

            public ModelNode execute(ModClusterStatus.LoadBalancer balancer) {
                return balancer.isStickySession() ? ModelNode.TRUE : ModelNode.FALSE;
            }
        }
        ,
        STICKY_SESSION_FORCE("sticky-session-force", ModelType.BOOLEAN){

            public ModelNode execute(ModClusterStatus.LoadBalancer balancer) {
                return balancer.isStickySessionForce() ? ModelNode.TRUE : ModelNode.FALSE;
            }
        }
        ,
        STICKY_SESSION_REMOVE("sticky-session-remove", ModelType.BOOLEAN){

            public ModelNode execute(ModClusterStatus.LoadBalancer balancer) {
                return balancer.isStickySessionRemove() ? ModelNode.TRUE : ModelNode.FALSE;
            }
        };

        private final AttributeDefinition definition;

        private LoadBalancerMetric(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setStorageRuntime()).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

