/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.impl.ElytronMessages;
import org.wildfly.security.password.impl.PasswordUtil;
import org.wildfly.security.password.interfaces.UnixMD5CryptPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

final class UnixMD5CryptPasswordImpl
extends AbstractPasswordImpl
implements UnixMD5CryptPassword {
    private static final long serialVersionUID = 8315521712238708363L;
    static final String MD5 = "MD5";
    static final byte[] MAGIC_BYTES = "$1$".getBytes(StandardCharsets.UTF_8);
    private final byte[] hash;
    private final byte[] salt;

    UnixMD5CryptPasswordImpl(byte[] clonedHash, byte[] clonedSalt) {
        this.hash = clonedHash;
        this.salt = clonedSalt;
    }

    UnixMD5CryptPasswordImpl(UnixMD5CryptPassword password) {
        this((byte[])password.getHash().clone(), UnixMD5CryptPasswordImpl.truncatedClone(password.getSalt()));
    }

    UnixMD5CryptPasswordImpl(SaltedHashPasswordSpec spec) {
        this((byte[])spec.getHash().clone(), UnixMD5CryptPasswordImpl.truncatedClone(spec.getSalt()));
    }

    UnixMD5CryptPasswordImpl(ClearPasswordSpec spec) throws NoSuchAlgorithmException {
        this.salt = PasswordUtil.generateRandomSalt(8);
        this.hash = UnixMD5CryptPasswordImpl.encode(UnixMD5CryptPasswordImpl.getNormalizedPasswordBytes(spec.getEncodedPassword()), this.salt);
    }

    UnixMD5CryptPasswordImpl(char[] password, Charset hashCharset) throws NoSuchAlgorithmException {
        this(password, PasswordUtil.generateRandomSalt(8), hashCharset);
    }

    UnixMD5CryptPasswordImpl(char[] password, SaltedPasswordAlgorithmSpec spec, Charset hashCharset) throws NoSuchAlgorithmException {
        this(password, UnixMD5CryptPasswordImpl.truncatedClone(spec.getSalt()), hashCharset);
    }

    UnixMD5CryptPasswordImpl(char[] password, byte[] salt, Charset hashCharset) throws NoSuchAlgorithmException {
        this(UnixMD5CryptPasswordImpl.encode(UnixMD5CryptPasswordImpl.getNormalizedPasswordBytes(password, hashCharset), salt), salt);
    }

    private static byte[] truncatedClone(byte[] salt) {
        if (salt.length <= 8) {
            return (byte[])salt.clone();
        }
        return Arrays.copyOf(salt, 8);
    }

    @Override
    public String getAlgorithm() {
        return "crypt-md5";
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(SaltedHashPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new SaltedHashPasswordSpec(this.getHash(), this.getSalt())));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        return this.verify(guess, StandardCharsets.UTF_8);
    }

    @Override
    boolean verify(char[] guess, Charset hashCharset) throws InvalidKeyException {
        byte[] test;
        byte[] guessAsBytes = UnixMD5CryptPasswordImpl.getNormalizedPasswordBytes(guess, hashCharset);
        try {
            test = UnixMD5CryptPasswordImpl.encode(guessAsBytes, this.getSalt());
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeyCannotVerifyPassword(e);
        }
        return MessageDigest.isEqual(this.getHash(), test);
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(SaltedHashPasswordSpec.class);
    }

    static byte[] encode(byte[] password, byte[] salt) throws NoSuchAlgorithmException {
        int i;
        if (salt.length > 8) {
            salt = Arrays.copyOfRange(salt, 0, 8);
        }
        MessageDigest digestA = UnixMD5CryptPasswordImpl.getMD5MessageDigest();
        digestA.update(password);
        digestA.update(MAGIC_BYTES);
        digestA.update(salt);
        MessageDigest digestB = UnixMD5CryptPasswordImpl.getMD5MessageDigest();
        digestB.update(password);
        digestB.update(salt);
        digestB.update(password);
        byte[] finalDigest = digestB.digest();
        for (i = password.length; i > 0; i -= 16) {
            digestA.update(finalDigest, 0, i > 16 ? 16 : i);
        }
        Arrays.fill(finalDigest, (byte)0);
        for (i = password.length; i > 0; i >>= 1) {
            if ((i & 1) == 1) {
                digestA.update(finalDigest, 0, 1);
                continue;
            }
            digestA.update(password, 0, 1);
        }
        finalDigest = digestA.digest();
        for (i = 0; i < 1000; ++i) {
            digestB = UnixMD5CryptPasswordImpl.getMD5MessageDigest();
            if ((i & 1) == 1) {
                digestB.update(password);
            } else {
                digestB.update(finalDigest, 0, 16);
            }
            if (i % 3 != 0) {
                digestB.update(salt);
            }
            if (i % 7 != 0) {
                digestB.update(password);
            }
            if ((i & 1) == 1) {
                digestB.update(finalDigest, 0, 16);
            } else {
                digestB.update(password);
            }
            finalDigest = digestB.digest();
        }
        return finalDigest;
    }

    static MessageDigest getMD5MessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(MD5);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)Arrays.hashCode(this.hash), (int)Arrays.hashCode(this.salt));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnixMD5CryptPasswordImpl)) {
            return false;
        }
        UnixMD5CryptPasswordImpl other = (UnixMD5CryptPasswordImpl)obj;
        return MessageDigest.isEqual(this.hash, other.hash) && Arrays.equals(this.salt, other.salt);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return UnixMD5CryptPassword.createRaw(this.getAlgorithm(), this.salt, this.hash);
    }

    @Override
    public UnixMD5CryptPasswordImpl clone() {
        return this;
    }
}

