/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.wildfly.security.http.oidc.ElytronMessages;

class JWTSigningUtils {
    JWTSigningUtils() {
    }

    public static KeyPair loadKeyPairFromKeyStore(String keyStoreFile, String storePassword, String keyPassword, String keyAlias, String keyStoreType) {
        InputStream stream = JWTSigningUtils.findFile(keyStoreFile);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(stream, storePassword.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
            if (privateKey == null) {
                throw ElytronMessages.log.unableToLoadKeyWithAlias(keyAlias);
            }
            PublicKey publicKey = keyStore.getCertificate(keyAlias).getPublicKey();
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            throw ElytronMessages.log.unableToLoadPrivateKey(e);
        }
    }

    public static InputStream findFile(String keystoreFile) {
        if (keystoreFile.startsWith("classpath:")) {
            String classPathLocation = keystoreFile.replace("classpath:", "");
            InputStream is = JWTSigningUtils.class.getClassLoader().getResourceAsStream(classPathLocation);
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classPathLocation);
            }
            if (is != null) {
                return is;
            }
            throw ElytronMessages.log.unableToFindKeystoreFile(keystoreFile);
        }
        try {
            return new FileInputStream(keystoreFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

